/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.zeebe.util;

import io.atomix.cluster.AtomixCluster;
import io.atomix.cluster.Member;
import io.atomix.cluster.MemberId;
import io.atomix.cluster.Node;
import io.atomix.cluster.NoopSnapshotStore;
import io.atomix.cluster.discovery.BootstrapDiscoveryProvider;
import io.atomix.cluster.discovery.NodeDiscoveryProvider;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.partition.PartitionManagementService;
import io.atomix.primitive.partition.PartitionMetadata;
import io.atomix.primitive.partition.impl.DefaultPartitionManagementService;
import io.atomix.raft.partition.RaftPartition;
import io.atomix.raft.partition.RaftPartitionConfig;
import io.atomix.raft.partition.RaftStorageConfig;
import io.atomix.raft.partition.impl.RaftPartitionServer;
import io.atomix.raft.zeebe.EntryValidator;
import io.atomix.utils.net.Address;
import io.camunda.zeebe.snapshots.ReceivableSnapshotStore;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class ZeebeTestNode {
    public static final String CLUSTER_ID = "zeebe";
    private static final String HOST = "localhost";
    private static final int BASE_PORT = 10000;
    private final Member member;
    private final Node node;
    private final File directory;
    private AtomixCluster cluster;
    private List<RaftPartition> partitions;
    private final MeterRegistry meterRegistry;

    public ZeebeTestNode(int id, File directory, MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
        String textualId = String.valueOf(id);
        this.directory = directory;
        this.node = Node.builder().withId(textualId).withHost(HOST).withPort(10000 + id).build();
        this.member = Member.member((MemberId)MemberId.from((String)textualId), (Address)this.node.address());
    }

    public RaftPartitionServer getPartitionServer(int id) {
        return this.getPartition(id).getServer();
    }

    RaftPartition getPartition(int id) {
        return this.partitions.stream().filter(p -> (Integer)p.id().id() == id).findFirst().orElse(null);
    }

    public CompletableFuture<Void> start(Collection<ZeebeTestNode> nodes) {
        this.cluster = this.buildCluster(nodes);
        Set members = nodes.stream().map(ZeebeTestNode::getMember).map(Member::id).collect(Collectors.toSet());
        members.add(this.member.id());
        PartitionId partitionId = PartitionId.from((String)"test", (int)1);
        Map<MemberId, Integer> priorityMap = members.stream().collect(Collectors.toMap(memberId -> memberId, memberId -> Integer.valueOf((String)((Object)memberId.id()))));
        Map.Entry primary = priorityMap.entrySet().stream().min(Map.Entry.comparingByValue()).orElseThrow();
        Set<PartitionMetadata> partitionDistribution = Set.of(new PartitionMetadata(partitionId, members, priorityMap, ((Integer)primary.getValue()).intValue(), (MemberId)primary.getKey()));
        this.partitions = this.buildPartitions(partitionDistribution);
        DefaultPartitionManagementService managementService = new DefaultPartitionManagementService(this.cluster.getMembershipService(), this.cluster.getCommunicationService());
        return this.cluster.start().thenCompose(ignored -> CompletableFuture.allOf((CompletableFuture[])this.partitions.stream().map(partition -> partition.bootstrap((PartitionManagementService)managementService, (ReceivableSnapshotStore)new NoopSnapshotStore())).toArray(CompletableFuture[]::new)));
    }

    private List<RaftPartition> buildPartitions(Set<PartitionMetadata> partitionDistribution) {
        return partitionDistribution.stream().map(partitionMetadata -> {
            RaftStorageConfig raftStorageConfig = new RaftStorageConfig();
            raftStorageConfig.setSegmentSize(1024L);
            RaftPartitionConfig raftPartitionConfig = new RaftPartitionConfig();
            raftPartitionConfig.setStorageConfig(raftStorageConfig);
            raftPartitionConfig.setPriorityElectionEnabled(false);
            raftPartitionConfig.setEntryValidator((EntryValidator)new EntryValidator.NoopEntryValidator());
            return new RaftPartition(partitionMetadata, raftPartitionConfig, new File(new File(this.directory, "log"), String.valueOf(this.member.id())), this.meterRegistry);
        }).toList();
    }

    private AtomixCluster buildCluster(Collection<ZeebeTestNode> nodes) {
        return AtomixCluster.builder((MeterRegistry)this.meterRegistry).withAddress(this.node.address()).withClusterId(CLUSTER_ID).withMembershipProvider(this.buildDiscoveryProvider(nodes)).withMemberId(this.getMemberId()).build();
    }

    public MemberId getMemberId() {
        return this.member.id();
    }

    private NodeDiscoveryProvider buildDiscoveryProvider(Collection<ZeebeTestNode> nodes) {
        return BootstrapDiscoveryProvider.builder().withNodes((Collection)nodes.stream().map(ZeebeTestNode::getNode).collect(Collectors.toList())).build();
    }

    public Node getNode() {
        return this.node;
    }

    public Member getMember() {
        return this.member;
    }

    public CompletableFuture<Void> stop() {
        return CompletableFuture.allOf((CompletableFuture[])this.partitions.stream().map(RaftPartition::close).toArray(CompletableFuture[]::new)).thenCompose(ignored -> this.cluster.stop());
    }

    public AtomixCluster getCluster() {
        return this.cluster;
    }

    public String toString() {
        return "ZeebeTestNode{member=" + String.valueOf(this.member) + "}";
    }
}

