/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.storage.serializer;

import io.atomix.cluster.MemberId;
import io.atomix.raft.cluster.RaftMember;
import io.atomix.raft.cluster.impl.DefaultRaftMember;
import io.atomix.raft.storage.log.entry.ApplicationEntry;
import io.atomix.raft.storage.log.entry.ConfigurationEntry;
import io.atomix.raft.storage.log.entry.InitialEntry;
import io.atomix.raft.storage.log.entry.RaftEntry;
import io.atomix.raft.storage.log.entry.RaftLogEntry;
import io.atomix.raft.storage.log.entry.SerializedApplicationEntry;
import io.atomix.raft.storage.serializer.RaftEntrySBESerializer;
import io.atomix.raft.storage.serializer.RaftEntrySerializer;
import java.time.Instant;
import java.util.Set;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class RaftEntrySBESerializerTest {
    final RaftEntrySerializer serializer = new RaftEntrySBESerializer();
    final MutableDirectBuffer buffer = new ExpandableArrayBuffer();

    @Test
    public void shouldCalculateActualApplicationEntrySize() {
        byte[] data = "Test".getBytes();
        SerializedApplicationEntry applicationEntry = new SerializedApplicationEntry(1L, 2L, (DirectBuffer)new UnsafeBuffer(data));
        int writtenBytes = this.serializer.writeApplicationEntry(5L, (ApplicationEntry)applicationEntry, this.buffer, 0);
        Assertions.assertThat((int)this.serializer.getApplicationEntrySerializedLength((ApplicationEntry)applicationEntry)).isEqualTo(writtenBytes);
    }

    @Test
    public void shouldWriteApplicationEntry() {
        byte[] data = "Test".getBytes();
        SerializedApplicationEntry applicationEntryWritten = new SerializedApplicationEntry(1L, 2L, (DirectBuffer)new UnsafeBuffer(data));
        RaftLogEntry raftLogEntryExpected = new RaftLogEntry(5L, (RaftEntry)applicationEntryWritten);
        this.serializer.writeApplicationEntry(5L, (ApplicationEntry)applicationEntryWritten, this.buffer, 0);
        RaftLogEntry raftLogEntryRead = this.serializer.readRaftLogEntry((DirectBuffer)this.buffer);
        Assertions.assertThat((boolean)raftLogEntryRead.isApplicationEntry()).isTrue();
        ApplicationEntry applicationEntryRead = raftLogEntryRead.getApplicationEntry();
        Assertions.assertThat((Object)applicationEntryRead).isEqualTo((Object)applicationEntryWritten);
        Assertions.assertThat((Object)raftLogEntryRead).isEqualTo((Object)raftLogEntryExpected);
    }

    @Test
    public void shouldWriteApplicationEntryAtAnyOffset() {
        int offset = 10;
        byte[] data = "Test".getBytes();
        SerializedApplicationEntry applicationEntryWritten = new SerializedApplicationEntry(1L, 2L, (DirectBuffer)new UnsafeBuffer(data));
        RaftLogEntry raftLogEntryExpected = new RaftLogEntry(5L, (RaftEntry)applicationEntryWritten);
        int length = this.serializer.writeApplicationEntry(5L, (ApplicationEntry)applicationEntryWritten, this.buffer, 10);
        RaftLogEntry raftLogEntryRead = this.serializer.readRaftLogEntry((DirectBuffer)new UnsafeBuffer((DirectBuffer)this.buffer, 10, length));
        Assertions.assertThat((boolean)raftLogEntryRead.isApplicationEntry()).isTrue();
        ApplicationEntry applicationEntryRead = raftLogEntryRead.getApplicationEntry();
        Assertions.assertThat((Object)applicationEntryRead).isEqualTo((Object)applicationEntryWritten);
        Assertions.assertThat((Object)raftLogEntryRead).isEqualTo((Object)raftLogEntryExpected);
    }

    @Test
    public void shouldCalculateActualInitialEntrySize() {
        InitialEntry initialEntry = new InitialEntry();
        int writtenBytes = this.serializer.writeInitialEntry(5L, initialEntry, this.buffer, 0);
        Assertions.assertThat((int)this.serializer.getInitialEntrySerializedLength()).isEqualTo(writtenBytes);
    }

    @Test
    public void shouldWriteInitialEntry() {
        InitialEntry initialEntryWritten = new InitialEntry();
        RaftLogEntry raftLogEntryExpected = new RaftLogEntry(5L, (RaftEntry)initialEntryWritten);
        this.serializer.writeInitialEntry(5L, initialEntryWritten, this.buffer, 0);
        RaftLogEntry raftLogEntryRead = this.serializer.readRaftLogEntry((DirectBuffer)this.buffer);
        Assertions.assertThat((boolean)raftLogEntryRead.isInitialEntry()).isTrue();
        Assertions.assertThat((Object)raftLogEntryRead).isEqualTo((Object)raftLogEntryExpected);
    }

    @Test
    public void shouldWriteInitialEntryAtAnyOffset() {
        int offset = 10;
        InitialEntry initialEntryWritten = new InitialEntry();
        RaftLogEntry raftLogEntryExpected = new RaftLogEntry(5L, (RaftEntry)initialEntryWritten);
        int length = this.serializer.writeInitialEntry(5L, initialEntryWritten, this.buffer, 10);
        RaftLogEntry raftLogEntryRead = this.serializer.readRaftLogEntry((DirectBuffer)new UnsafeBuffer((DirectBuffer)this.buffer, 10, length));
        Assertions.assertThat((boolean)raftLogEntryRead.isInitialEntry()).isTrue();
        Assertions.assertThat((Object)raftLogEntryExpected).isEqualTo((Object)raftLogEntryRead);
    }

    @Test
    public void shouldCalculateActualConfigurationEntrySize() {
        Set<DefaultRaftMember> members = Set.of(new DefaultRaftMember(MemberId.from((String)"1"), RaftMember.Type.ACTIVE, Instant.ofEpochMilli(123456L)), new DefaultRaftMember(MemberId.from((String)"222"), RaftMember.Type.PASSIVE, Instant.ofEpochMilli(123457L)), new DefaultRaftMember(MemberId.from((String)""), RaftMember.Type.PASSIVE, Instant.ofEpochMilli(123457L)), new DefaultRaftMember(MemberId.from((String)"hello1"), RaftMember.Type.PROMOTABLE, Instant.ofEpochMilli(123458L)));
        ConfigurationEntry configurationEntry = new ConfigurationEntry(1234L, members);
        int writtenBytes = this.serializer.writeConfigurationEntry(5L, configurationEntry, this.buffer, 0);
        Assertions.assertThat((int)this.serializer.getConfigurationEntrySerializedLength(configurationEntry)).isEqualTo(writtenBytes);
    }

    @Test
    public void shouldWriteConfigurationEntry() {
        Set<DefaultRaftMember> members = Set.of(new DefaultRaftMember(MemberId.from((String)"1"), RaftMember.Type.ACTIVE, Instant.ofEpochMilli(123456L)), new DefaultRaftMember(MemberId.from((String)"2"), RaftMember.Type.PASSIVE, Instant.ofEpochMilli(123457L)), new DefaultRaftMember(MemberId.from((String)"3"), RaftMember.Type.PROMOTABLE, Instant.ofEpochMilli(123458L)));
        ConfigurationEntry configurationEntryWritten = new ConfigurationEntry(1234L, members);
        this.serializer.writeConfigurationEntry(5L, configurationEntryWritten, this.buffer, 0);
        RaftLogEntry entryRead = this.serializer.readRaftLogEntry((DirectBuffer)this.buffer);
        Assertions.assertThat((boolean)entryRead.isConfigurationEntry()).isTrue();
        ConfigurationEntry configurationEntryRead = entryRead.getConfigurationEntry();
        Assertions.assertThat((boolean)configurationEntryRead.requiresJointConsensus()).isFalse();
        Assertions.assertThat((long)configurationEntryRead.timestamp()).isEqualTo(configurationEntryWritten.timestamp());
        Assertions.assertThat((String)configurationEntryRead.toString()).isEqualTo(configurationEntryWritten.toString());
    }

    @Test
    public void shouldWriteConfigurationEntryAtAnyOffset() {
        int offset = 10;
        Set<DefaultRaftMember> members = Set.of(new DefaultRaftMember(MemberId.from((String)"1"), RaftMember.Type.ACTIVE, Instant.ofEpochMilli(123456L)), new DefaultRaftMember(MemberId.from((String)"2"), RaftMember.Type.PASSIVE, Instant.ofEpochMilli(123457L)), new DefaultRaftMember(MemberId.from((String)"3"), RaftMember.Type.PROMOTABLE, Instant.ofEpochMilli(123458L)));
        ConfigurationEntry configurationEntryWritten = new ConfigurationEntry(1234L, members);
        int length = this.serializer.writeConfigurationEntry(5L, configurationEntryWritten, this.buffer, 10);
        RaftLogEntry entryRead = this.serializer.readRaftLogEntry((DirectBuffer)new UnsafeBuffer((DirectBuffer)this.buffer, 10, length));
        Assertions.assertThat((boolean)entryRead.isConfigurationEntry()).isTrue();
        ConfigurationEntry configurationEntryRead = entryRead.getConfigurationEntry();
        Assertions.assertThat((long)configurationEntryRead.timestamp()).isEqualTo(configurationEntryWritten.timestamp());
        Assertions.assertThat((String)configurationEntryRead.toString()).isEqualTo(configurationEntryWritten.toString());
    }

    @Test
    public void shouldWriteConfigurationEntryWithChangedMembers() {
        Set<DefaultRaftMember> oldMembers = Set.of(new DefaultRaftMember(MemberId.from((String)"1"), RaftMember.Type.ACTIVE, Instant.ofEpochMilli(123456L)), new DefaultRaftMember(MemberId.from((String)"2"), RaftMember.Type.ACTIVE, Instant.ofEpochMilli(123457L)), new DefaultRaftMember(MemberId.from((String)"3"), RaftMember.Type.ACTIVE, Instant.ofEpochMilli(123458L)));
        Set<DefaultRaftMember> newMembers = Set.of(new DefaultRaftMember(MemberId.from((String)"1"), RaftMember.Type.ACTIVE, Instant.ofEpochMilli(123456L)), new DefaultRaftMember(MemberId.from((String)"2"), RaftMember.Type.ACTIVE, Instant.ofEpochMilli(123457L)), new DefaultRaftMember(MemberId.from((String)"3"), RaftMember.Type.ACTIVE, Instant.ofEpochMilli(123458L)), new DefaultRaftMember(MemberId.from((String)"4"), RaftMember.Type.ACTIVE, Instant.ofEpochMilli(123459L)));
        ConfigurationEntry configurationEntryWritten = new ConfigurationEntry(1234L, oldMembers, newMembers);
        this.serializer.writeConfigurationEntry(5L, configurationEntryWritten, this.buffer, 0);
        RaftLogEntry entryRead = this.serializer.readRaftLogEntry((DirectBuffer)this.buffer);
        Assertions.assertThat((boolean)entryRead.isConfigurationEntry()).isTrue();
        ConfigurationEntry configurationEntryRead = entryRead.getConfigurationEntry();
        Assertions.assertThat((boolean)configurationEntryRead.requiresJointConsensus()).isTrue();
        Assertions.assertThat((long)configurationEntryRead.timestamp()).isEqualTo(configurationEntryWritten.timestamp());
        Assertions.assertThat((String)configurationEntryRead.toString()).isEqualTo(configurationEntryWritten.toString());
    }

    @Test
    public void shouldCalculateActualConfigurationEntrySizeWithOldAndNewMembers() {
        Set<DefaultRaftMember> oldMembers = Set.of(new DefaultRaftMember(MemberId.from((String)"1"), RaftMember.Type.ACTIVE, Instant.ofEpochMilli(123456L)), new DefaultRaftMember(MemberId.from((String)"2"), RaftMember.Type.PASSIVE, Instant.ofEpochMilli(123457L)), new DefaultRaftMember(MemberId.from((String)"3"), RaftMember.Type.PASSIVE, Instant.ofEpochMilli(123457L)));
        Set<DefaultRaftMember> newMembers = Set.of(new DefaultRaftMember(MemberId.from((String)"2"), RaftMember.Type.ACTIVE, Instant.ofEpochMilli(123457L)), new DefaultRaftMember(MemberId.from((String)"3"), RaftMember.Type.ACTIVE, Instant.ofEpochMilli(123457L)), new DefaultRaftMember(MemberId.from((String)"4"), RaftMember.Type.ACTIVE, Instant.ofEpochMilli(123457L)), new DefaultRaftMember(MemberId.from((String)"5"), RaftMember.Type.ACTIVE, Instant.ofEpochMilli(123457L)));
        ConfigurationEntry configurationEntry = new ConfigurationEntry(1234L, newMembers, oldMembers);
        int writtenBytes = this.serializer.writeConfigurationEntry(5L, configurationEntry, this.buffer, 0);
        Assertions.assertThat((int)this.serializer.getConfigurationEntrySerializedLength(configurationEntry)).isEqualTo(writtenBytes);
    }
}

