/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.snapshot;

import io.atomix.raft.snapshot.InMemorySnapshot;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.snapshots.PersistedSnapshot;
import io.camunda.zeebe.snapshots.PersistedSnapshotListener;
import io.camunda.zeebe.snapshots.ReceivableSnapshotStore;
import io.camunda.zeebe.snapshots.ReceivedSnapshot;
import io.camunda.zeebe.snapshots.SnapshotException;
import io.camunda.zeebe.snapshots.SnapshotId;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;

public class TestSnapshotStore
implements ReceivableSnapshotStore {
    final AtomicReference<InMemorySnapshot> currentPersistedSnapshot;
    final NavigableMap<SnapshotId, InMemorySnapshot> persistedSnapshots = new ConcurrentSkipListMap<SnapshotId, InMemorySnapshot>();
    final List<InMemorySnapshot> receivedSnapshots = new CopyOnWriteArrayList<InMemorySnapshot>();
    final List<PersistedSnapshotListener> listeners = new CopyOnWriteArrayList<PersistedSnapshotListener>();
    private Runnable interceptorOnNewSnapshot = () -> {};

    public TestSnapshotStore(AtomicReference<InMemorySnapshot> persistedSnapshotRef) {
        this.currentPersistedSnapshot = persistedSnapshotRef;
    }

    public boolean hasSnapshotId(String id) {
        return this.currentPersistedSnapshot.get() != null && this.currentPersistedSnapshot.get().getId().equals(id);
    }

    public Optional<PersistedSnapshot> getLatestSnapshot() {
        return Optional.ofNullable((PersistedSnapshot)this.currentPersistedSnapshot.get());
    }

    public ActorFuture<Set<PersistedSnapshot>> getAvailableSnapshots() {
        return CompletableActorFuture.completed(new HashSet(this.persistedSnapshots.values()));
    }

    public ActorFuture<Long> getCompactionBound() {
        return CompletableActorFuture.completed((Object)Optional.ofNullable(this.persistedSnapshots.firstEntry()).map(Map.Entry::getValue).map(InMemorySnapshot::getCompactionBound).orElse(0L));
    }

    public ActorFuture<Void> purgePendingSnapshots() {
        this.receivedSnapshots.clear();
        return CompletableActorFuture.completed(null);
    }

    public ActorFuture<Boolean> addSnapshotListener(PersistedSnapshotListener listener) {
        this.listeners.add(listener);
        return null;
    }

    public ActorFuture<Boolean> removeSnapshotListener(PersistedSnapshotListener listener) {
        this.listeners.remove(listener);
        return null;
    }

    public long getCurrentSnapshotIndex() {
        if (this.currentPersistedSnapshot.get() == null) {
            return 0L;
        }
        return this.currentPersistedSnapshot.get().getIndex();
    }

    public ActorFuture<Void> delete() {
        this.currentPersistedSnapshot.set(null);
        this.receivedSnapshots.clear();
        this.persistedSnapshots.clear();
        return null;
    }

    public Path getPath() {
        return null;
    }

    public ActorFuture<ReceivedSnapshot> newReceivedSnapshot(String snapshotId) {
        if (Optional.ofNullable(this.currentPersistedSnapshot.get()).map(PersistedSnapshot::getId).orElse("").equals(snapshotId)) {
            CompletableActorFuture.completedExceptionally((Throwable)new SnapshotException.SnapshotAlreadyExistsException("Snapshot with this ID is already persisted"));
        }
        InMemorySnapshot newSnapshot = new InMemorySnapshot(this, snapshotId);
        this.receivedSnapshots.add(newSnapshot);
        return CompletableActorFuture.completed((Object)newSnapshot);
    }

    public void close() {
    }

    public void newSnapshot(InMemorySnapshot persistedSnapshot) {
        this.interceptorOnNewSnapshot.run();
        this.currentPersistedSnapshot.set(persistedSnapshot);
        HashMap<SnapshotId, InMemorySnapshot> olderSnapshots = new HashMap<SnapshotId, InMemorySnapshot>(this.persistedSnapshots.headMap(persistedSnapshot.snapshotId(), false));
        for (Map.Entry<SnapshotId, InMemorySnapshot> snapshot : olderSnapshots.entrySet()) {
            if (snapshot.getValue().isReserved()) continue;
            this.persistedSnapshots.remove(snapshot.getKey());
        }
        this.persistedSnapshots.put(persistedSnapshot.snapshotId(), persistedSnapshot);
        this.listeners.forEach(l -> l.onNewSnapshot((PersistedSnapshot)persistedSnapshot));
    }

    public void interceptOnNewSnapshot(Runnable interceptor) {
        this.interceptorOnNewSnapshot = interceptor;
    }
}

