/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.impl;

import io.atomix.raft.DeterministicSingleThreadContext;
import io.atomix.raft.impl.PriorityElectionTimer;
import io.atomix.utils.concurrent.ThreadContext;
import java.time.Duration;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.jmock.lib.concurrent.DeterministicScheduler;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PriorityElectionTimerTest {
    private final Logger log = LoggerFactory.getLogger(PriorityElectionTimerTest.class);
    private final DeterministicSingleThreadContext threadContext = new DeterministicSingleThreadContext(new DeterministicScheduler());

    PriorityElectionTimerTest() {
    }

    @AfterEach
    void afterEach() {
        this.threadContext.close();
    }

    @Test
    void shouldLowerPriorityNodeEventuallyStartsAnElection() {
        AtomicInteger triggerCount = new AtomicInteger();
        Duration electionTimeout = Duration.ofMillis(100L);
        int targetPriority = 4;
        PriorityElectionTimer timer = new PriorityElectionTimer(electionTimeout, (ThreadContext)this.threadContext, triggerCount::getAndIncrement, this.log, 4, 1);
        timer.reset();
        for (int i = 0; i < 4; ++i) {
            this.threadContext.getDeterministicScheduler().tick(electionTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)triggerCount.get()).describedAs("Time is triggered once", new Object[0])).isOne();
    }

    @Test
    void shouldHighPriorityNodeStartElectionFirst() {
        String highPrioId = "highPrioTimer";
        String lowPrioId = "lowPrioTimer";
        CopyOnWriteArrayList electionOrder = new CopyOnWriteArrayList();
        int targetPriority = 4;
        Duration electionTimeout = Duration.ofMillis(100L);
        PriorityElectionTimer timerHighPrio = new PriorityElectionTimer(electionTimeout, (ThreadContext)this.threadContext, () -> electionOrder.add("highPrioTimer"), this.log, 4, 4);
        PriorityElectionTimer timerLowPrio = new PriorityElectionTimer(electionTimeout, (ThreadContext)this.threadContext, () -> electionOrder.add("lowPrioTimer"), this.log, 4, 1);
        timerLowPrio.reset();
        timerHighPrio.reset();
        for (int i = 0; i < 4; ++i) {
            this.threadContext.getDeterministicScheduler().tick(electionTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        ((ListAssert)Assertions.assertThat(electionOrder).as("both elections should have been triggered eventually", new Object[0])).contains((Object[])new String[]{"highPrioTimer", "lowPrioTimer"});
        ((AbstractStringAssert)Assertions.assertThat((String)((String)electionOrder.get(0))).as("the first election triggered should have been the high priority election", new Object[0])).isEqualTo("highPrioTimer");
    }

    @Test
    void canChangePriorityDynamically() {
        String highPrioId = "highPrioTimer";
        String lowPrioId = "lowPrioTimer";
        CopyOnWriteArrayList electionOrder = new CopyOnWriteArrayList();
        int targetPriority = 4;
        Duration electionTimeout = Duration.ofMillis(100L);
        PriorityElectionTimer timerLowPrio = new PriorityElectionTimer(electionTimeout, (ThreadContext)this.threadContext, () -> electionOrder.add("lowPrioTimer"), this.log, 4, 2);
        PriorityElectionTimer timerHighPrio = new PriorityElectionTimer(electionTimeout, (ThreadContext)this.threadContext, () -> electionOrder.add("highPrioTimer"), this.log, 4, 1);
        timerLowPrio.reset();
        timerHighPrio.reset();
        this.threadContext.getDeterministicScheduler().tick(electionTimeout.toMillis(), TimeUnit.MILLISECONDS);
        timerLowPrio.setNodePriority(1);
        timerHighPrio.setNodePriority(4);
        for (int i = 0; i < 3; ++i) {
            this.threadContext.getDeterministicScheduler().tick(electionTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        ((ListAssert)Assertions.assertThat(electionOrder).as("both elections should have been triggered eventually", new Object[0])).contains((Object[])new String[]{"highPrioTimer", "lowPrioTimer"});
        ((AbstractStringAssert)Assertions.assertThat((String)((String)electionOrder.get(0))).as("the first election triggered should have been the high priority election", new Object[0])).isEqualTo("highPrioTimer");
    }
}

