/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.cluster.impl;

import io.atomix.cluster.MemberId;
import io.atomix.raft.cluster.RaftMember;
import io.atomix.raft.cluster.impl.DefaultRaftMember;
import io.atomix.raft.cluster.impl.RaftClusterContext;
import io.atomix.raft.cluster.impl.RaftMemberContext;
import io.atomix.raft.impl.RaftContext;
import io.atomix.raft.storage.system.Configuration;
import io.atomix.raft.storage.system.MetaStore;
import io.atomix.raft.utils.VoteQuorum;
import io.atomix.utils.concurrent.Scheduled;
import io.atomix.utils.concurrent.ThreadContext;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.mockito.MockSettings;
import org.mockito.Mockito;

final class RaftClusterContextTest {
    RaftClusterContextTest() {
    }

    @Test
    void shouldConfigureFromStored() {
        DefaultRaftMember localMember = new DefaultRaftMember(new MemberId("1"), RaftMember.Type.ACTIVE, Instant.now());
        List<DefaultRaftMember> remoteMembers = List.of(new DefaultRaftMember(new MemberId("2"), RaftMember.Type.ACTIVE, Instant.now()), new DefaultRaftMember(new MemberId("3"), RaftMember.Type.ACTIVE, Instant.now()));
        List<DefaultRaftMember> members = Stream.concat(Stream.of(localMember), remoteMembers.stream()).toList();
        Configuration configuration = new Configuration(1L, 1L, Instant.now().toEpochMilli(), members);
        RaftContext raft = this.raftWithStoredConfiguration(configuration);
        RaftClusterContext context = new RaftClusterContext(localMember.memberId(), raft);
        context.bootstrap(new MemberId[0]).join();
        Assertions.assertThat((Comparable)context.getLocalMember().memberId()).isEqualTo((Object)MemberId.from((String)"1"));
        Assertions.assertThat((boolean)context.inJointConsensus()).isFalse();
        Assertions.assertThat((Collection)context.getMembers()).containsAll(members);
        Assertions.assertThat((boolean)context.isSingleMemberCluster()).isFalse();
        Assertions.assertThat((Collection)context.getVotingMembers()).containsAll(remoteMembers);
        Assertions.assertThat(context.getReplicationTargets().stream().map(RaftMemberContext::getMember).map(RaftMember.class::cast)).containsAll(remoteMembers);
        ((ListAssert)Assertions.assertThat(members).allMatch(member -> context.isMember(member.memberId()))).allSatisfy(member -> Assertions.assertThat((Object)context.getMember(member.memberId())).isNotNull());
        Assertions.assertThat(remoteMembers).allSatisfy(member -> Assertions.assertThat((Object)context.getMemberContext(member.memberId())).isNotNull());
    }

    @Test
    void shouldReconfigureOverStored() {
        DefaultRaftMember localMember = new DefaultRaftMember(new MemberId("1"), RaftMember.Type.ACTIVE, Instant.now());
        List<DefaultRaftMember> remoteMembers = List.of(new DefaultRaftMember(new MemberId("2"), RaftMember.Type.ACTIVE, Instant.now()), new DefaultRaftMember(new MemberId("3"), RaftMember.Type.ACTIVE, Instant.now()));
        List<DefaultRaftMember> members = Stream.concat(Stream.of(localMember), remoteMembers.stream()).toList();
        RaftContext raft = this.raftWithStoredConfiguration(new Configuration(1L, 1L, Instant.now().toEpochMilli(), List.of(localMember)));
        RaftClusterContext context = new RaftClusterContext(localMember.memberId(), raft);
        context.bootstrap(List.of()).join();
        context.configure(new Configuration(2L, 1L, Instant.now().toEpochMilli(), members));
        Assertions.assertThat((Comparable)context.getLocalMember().memberId()).isEqualTo((Object)MemberId.from((String)"1"));
        Assertions.assertThat((boolean)context.inJointConsensus()).isFalse();
        Assertions.assertThat((Collection)context.getMembers()).containsAll(members);
        Assertions.assertThat((boolean)context.isSingleMemberCluster()).isFalse();
        Assertions.assertThat((Collection)context.getVotingMembers()).containsAll(remoteMembers);
        Assertions.assertThat(context.getReplicationTargets().stream().map(RaftMemberContext::getMember).map(RaftMember.class::cast)).containsAll(remoteMembers);
        ((ListAssert)Assertions.assertThat(members).allMatch(member -> context.isMember(member.memberId()))).allSatisfy(member -> Assertions.assertThat((Object)context.getMember(member.memberId())).isNotNull());
        Assertions.assertThat(remoteMembers).allSatisfy(member -> Assertions.assertThat((Object)context.getMemberContext(member.memberId())).isNotNull());
    }

    @Test
    void shouldRemoveContextsOnReconfiguration() {
        DefaultRaftMember localMember = new DefaultRaftMember(new MemberId("1"), RaftMember.Type.ACTIVE, Instant.now());
        List<DefaultRaftMember> remoteMembers = List.of(new DefaultRaftMember(new MemberId("2"), RaftMember.Type.ACTIVE, Instant.now()), new DefaultRaftMember(new MemberId("3"), RaftMember.Type.ACTIVE, Instant.now()));
        List<DefaultRaftMember> members = Stream.concat(Stream.of(localMember), remoteMembers.stream()).toList();
        RaftContext raft = this.raftWithStoredConfiguration(new Configuration(1L, 1L, Instant.now().toEpochMilli(), members));
        RaftClusterContext context = new RaftClusterContext(localMember.memberId(), raft);
        context.bootstrap(List.of()).join();
        context.configure(new Configuration(2L, 1L, Instant.now().toEpochMilli(), List.of(localMember)));
        Assertions.assertThat((Comparable)context.getLocalMember().memberId()).isEqualTo((Object)MemberId.from((String)"1"));
        Assertions.assertThat((boolean)context.inJointConsensus()).isFalse();
        Assertions.assertThat((Collection)context.getMembers()).containsExactly((Object[])new RaftMember[]{localMember});
        Assertions.assertThat((boolean)context.isSingleMemberCluster()).isTrue();
        Assertions.assertThat((Collection)context.getVotingMembers()).isEmpty();
        Assertions.assertThat((Collection)context.getReplicationTargets()).isEmpty();
        ((ListAssert)((ListAssert)Assertions.assertThat(remoteMembers).noneMatch(member -> context.isMember(member.memberId()))).allSatisfy(member -> Assertions.assertThat((Object)context.getMember(member.memberId())).isNull())).allSatisfy(member -> Assertions.assertThat((Object)context.getMemberContext(member.memberId())).isNull());
    }

    @Test
    void shouldUpdateMemberType() {
        DefaultRaftMember localMember = new DefaultRaftMember(new MemberId("1"), RaftMember.Type.ACTIVE, Instant.now());
        List<DefaultRaftMember> oldRemoteMembers = List.of(new DefaultRaftMember(new MemberId("2"), RaftMember.Type.ACTIVE, Instant.now()), new DefaultRaftMember(new MemberId("3"), RaftMember.Type.ACTIVE, Instant.now()));
        List<DefaultRaftMember> oldMembers = Stream.concat(Stream.of(localMember), oldRemoteMembers.stream()).toList();
        RaftContext raft = this.raftWithStoredConfiguration(new Configuration(1L, 1L, Instant.now().toEpochMilli(), oldMembers));
        RaftClusterContext context = new RaftClusterContext(localMember.memberId(), raft);
        context.bootstrap(List.of()).join();
        DefaultRaftMember newLocalMember = new DefaultRaftMember(new MemberId("1"), RaftMember.Type.ACTIVE, Instant.now());
        List<DefaultRaftMember> newRemoteMembers = List.of(new DefaultRaftMember(new MemberId("2"), RaftMember.Type.PASSIVE, Instant.now()), new DefaultRaftMember(new MemberId("3"), RaftMember.Type.PASSIVE, Instant.now()));
        List<DefaultRaftMember> newMembers = Stream.concat(Stream.of(newLocalMember), newRemoteMembers.stream()).toList();
        context.configure(new Configuration(2L, 1L, Instant.now().toEpochMilli(), newMembers, List.of()));
        Assertions.assertThat((Comparable)context.getLocalMember().memberId()).isEqualTo((Object)MemberId.from((String)"1"));
        Assertions.assertThat((Comparable)context.getLocalMember().getType()).isEqualTo((Object)RaftMember.Type.ACTIVE);
        Assertions.assertThat((boolean)context.isSingleMemberCluster()).isTrue();
        Assertions.assertThat((Collection)context.getMembers()).containsExactlyInAnyOrderElementsOf(newMembers);
        ((ListAssert)Assertions.assertThat(newRemoteMembers).allMatch(member -> context.isMember(member.memberId()))).allSatisfy(member -> Assertions.assertThat((Comparable)context.getMember(member.memberId()).getType()).isEqualTo((Object)RaftMember.Type.PASSIVE));
    }

    @Test
    void shouldCountVoteFromLocalMember() {
        DefaultRaftMember localMember = new DefaultRaftMember(new MemberId("1"), RaftMember.Type.ACTIVE, Instant.now());
        List<DefaultRaftMember> remoteMembers = List.of(new DefaultRaftMember(new MemberId("2"), RaftMember.Type.ACTIVE, Instant.now()), new DefaultRaftMember(new MemberId("3"), RaftMember.Type.ACTIVE, Instant.now()));
        List<DefaultRaftMember> members = Stream.concat(Stream.of(localMember), remoteMembers.stream()).toList();
        RaftContext raft = this.raftWithStoredConfiguration(new Configuration(1L, 1L, Instant.now().toEpochMilli(), members));
        RaftClusterContext context = new RaftClusterContext(localMember.memberId(), raft);
        context.bootstrap(List.of()).join();
        Consumer callback = (Consumer)Mockito.mock((Object[])new Consumer[0]);
        VoteQuorum quorum = context.getVoteQuorum(callback);
        quorum.succeed(new MemberId("2"));
        ((Consumer)Mockito.verify((Object)callback)).accept(true);
    }

    @Test
    void shouldRequireJointConsensusVotes() {
        DefaultRaftMember localMember = new DefaultRaftMember(new MemberId("1"), RaftMember.Type.ACTIVE, Instant.now());
        List<DefaultRaftMember> oldRemoteMembers = List.of(new DefaultRaftMember(new MemberId("2"), RaftMember.Type.ACTIVE, Instant.now()), new DefaultRaftMember(new MemberId("3"), RaftMember.Type.ACTIVE, Instant.now()));
        List<DefaultRaftMember> oldMembers = Stream.concat(Stream.of(localMember), oldRemoteMembers.stream()).toList();
        List<DefaultRaftMember> newRemoteMembers = List.of(new DefaultRaftMember(new MemberId("2"), RaftMember.Type.ACTIVE, Instant.now()), new DefaultRaftMember(new MemberId("4"), RaftMember.Type.ACTIVE, Instant.now()));
        List<DefaultRaftMember> newMembers = Stream.concat(Stream.of(localMember), newRemoteMembers.stream()).toList();
        RaftContext raft = this.raftWithStoredConfiguration(new Configuration(1L, 1L, Instant.now().toEpochMilli(), newMembers, oldMembers));
        RaftClusterContext context = new RaftClusterContext(localMember.memberId(), raft);
        context.bootstrap(List.of()).join();
        Consumer callback = (Consumer)Mockito.mock((Object[])new Consumer[0]);
        VoteQuorum quorum = context.getVoteQuorum(callback);
        quorum.succeed(new MemberId("4"));
        Mockito.verifyNoInteractions((Object[])new Object[]{callback});
        quorum.succeed(new MemberId("2"));
        ((Consumer)Mockito.verify((Object)callback)).accept(true);
    }

    @Test
    void shouldCalculateQuorum() {
        DefaultRaftMember localMember = new DefaultRaftMember(new MemberId("1"), RaftMember.Type.ACTIVE, Instant.now());
        List<DefaultRaftMember> remoteMembers = List.of(new DefaultRaftMember(new MemberId("2"), RaftMember.Type.ACTIVE, Instant.now()), new DefaultRaftMember(new MemberId("3"), RaftMember.Type.ACTIVE, Instant.now()), new DefaultRaftMember(new MemberId("4"), RaftMember.Type.ACTIVE, Instant.now()), new DefaultRaftMember(new MemberId("5"), RaftMember.Type.ACTIVE, Instant.now()));
        List<DefaultRaftMember> members = Stream.concat(Stream.of(localMember), remoteMembers.stream()).toList();
        RaftContext raft = this.raftWithStoredConfiguration(new Configuration(1L, 1L, Instant.now().toEpochMilli(), members));
        RaftClusterContext context = new RaftClusterContext(localMember.memberId(), raft);
        context.bootstrap(List.of()).join();
        context.getMemberContext(new MemberId("2")).setMatchIndex(2L);
        context.getMemberContext(new MemberId("3")).setMatchIndex(3L);
        context.getMemberContext(new MemberId("4")).setMatchIndex(4L);
        context.getMemberContext(new MemberId("5")).setMatchIndex(5L);
        Assertions.assertThat((Optional)context.getQuorumFor(RaftMemberContext::getMatchIndex)).hasValue((Object)4L);
    }

    @Test
    void shouldNotIncludeLocalMemberInQuorumWhenItIsNotPartOfNewConfiguration() {
        DefaultRaftMember localMember = new DefaultRaftMember(new MemberId("1"), RaftMember.Type.ACTIVE, Instant.now());
        List<DefaultRaftMember> remoteMembers = List.of(new DefaultRaftMember(new MemberId("2"), RaftMember.Type.ACTIVE, Instant.now()), new DefaultRaftMember(new MemberId("3"), RaftMember.Type.ACTIVE, Instant.now()));
        RaftContext raft = this.raftWithStoredConfiguration(new Configuration(1L, 1L, Instant.now().toEpochMilli(), remoteMembers));
        RaftClusterContext context = new RaftClusterContext(localMember.memberId(), raft);
        context.bootstrap(List.of()).join();
        context.getMemberContext(new MemberId("2")).setMatchIndex(2L);
        context.getMemberContext(new MemberId("3")).setMatchIndex(3L);
        Assertions.assertThat((Optional)context.getQuorumFor(RaftMemberContext::getMatchIndex)).hasValue((Object)2L);
    }

    @Test
    void quorumWhenNewMembersAreAhead() {
        DefaultRaftMember localMember = new DefaultRaftMember(new MemberId("1"), RaftMember.Type.ACTIVE, Instant.now());
        List<DefaultRaftMember> oldRemoteMembers = List.of(new DefaultRaftMember(new MemberId("2"), RaftMember.Type.ACTIVE, Instant.now()), new DefaultRaftMember(new MemberId("3"), RaftMember.Type.ACTIVE, Instant.now()));
        List<DefaultRaftMember> oldMembers = Stream.concat(Stream.of(localMember), oldRemoteMembers.stream()).toList();
        List<DefaultRaftMember> newRemoteMembers = List.of(new DefaultRaftMember(new MemberId("2"), RaftMember.Type.ACTIVE, Instant.now()), new DefaultRaftMember(new MemberId("4"), RaftMember.Type.ACTIVE, Instant.now()));
        List<DefaultRaftMember> newMembers = Stream.concat(Stream.of(localMember), newRemoteMembers.stream()).toList();
        RaftContext raft = this.raftWithStoredConfiguration(new Configuration(1L, 1L, Instant.now().toEpochMilli(), newMembers, oldMembers));
        RaftClusterContext context = new RaftClusterContext(localMember.memberId(), raft);
        context.bootstrap(List.of()).join();
        for (RaftMember raftMember : newRemoteMembers) {
            context.getMemberContext(raftMember.memberId()).setMatchIndex(5L);
        }
        for (RaftMember raftMember : oldRemoteMembers) {
            context.getMemberContext(raftMember.memberId()).setMatchIndex(2L);
        }
        Assertions.assertThat((Optional)context.getQuorumFor(RaftMemberContext::getMatchIndex)).hasValue((Object)2L);
    }

    @Test
    void quorumWhenOldMembersAreAhead() {
        DefaultRaftMember localMember = new DefaultRaftMember(new MemberId("1"), RaftMember.Type.ACTIVE, Instant.now());
        List<DefaultRaftMember> oldRemoteMembers = List.of(new DefaultRaftMember(new MemberId("2"), RaftMember.Type.ACTIVE, Instant.now()), new DefaultRaftMember(new MemberId("3"), RaftMember.Type.ACTIVE, Instant.now()));
        List<DefaultRaftMember> oldMembers = Stream.concat(Stream.of(localMember), oldRemoteMembers.stream()).toList();
        List<DefaultRaftMember> newRemoteMembers = List.of(new DefaultRaftMember(new MemberId("4"), RaftMember.Type.ACTIVE, Instant.now()), new DefaultRaftMember(new MemberId("5"), RaftMember.Type.ACTIVE, Instant.now()));
        List<DefaultRaftMember> newMembers = Stream.concat(Stream.of(localMember), newRemoteMembers.stream()).toList();
        RaftContext raft = this.raftWithStoredConfiguration(new Configuration(1L, 1L, Instant.now().toEpochMilli(), newMembers, oldMembers));
        RaftClusterContext context = new RaftClusterContext(localMember.memberId(), raft);
        context.bootstrap(List.of()).join();
        for (RaftMember raftMember : newRemoteMembers) {
            context.getMemberContext(raftMember.memberId()).setMatchIndex(2L);
        }
        for (RaftMember raftMember : oldRemoteMembers) {
            context.getMemberContext(raftMember.memberId()).setMatchIndex(5L);
        }
        Assertions.assertThat((Optional)context.getQuorumFor(RaftMemberContext::getMatchIndex)).hasValue((Object)2L);
    }

    @Test
    void quorumWhenClusterBecomesSingleMember() {
        DefaultRaftMember localMember = new DefaultRaftMember(new MemberId("1"), RaftMember.Type.ACTIVE, Instant.now());
        List<DefaultRaftMember> oldRemoteMembers = List.of(new DefaultRaftMember(new MemberId("2"), RaftMember.Type.ACTIVE, Instant.now()), new DefaultRaftMember(new MemberId("3"), RaftMember.Type.ACTIVE, Instant.now()));
        List<DefaultRaftMember> oldMembers = Stream.concat(Stream.of(localMember), oldRemoteMembers.stream()).toList();
        List<DefaultRaftMember> newMembers = List.of(localMember);
        RaftContext raft = this.raftWithStoredConfiguration(new Configuration(1L, 1L, Instant.now().toEpochMilli(), newMembers, oldMembers));
        RaftClusterContext context = new RaftClusterContext(localMember.memberId(), raft);
        context.bootstrap(List.of()).join();
        for (RaftMember raftMember : oldRemoteMembers) {
            context.getMemberContext(raftMember.memberId()).setMatchIndex(5L);
        }
        Assertions.assertThat((Optional)context.getQuorumFor(RaftMemberContext::getMatchIndex)).hasValue((Object)5L);
    }

    @Test
    void quorumWhenClusterWasSingleMember() {
        DefaultRaftMember localMember = new DefaultRaftMember(new MemberId("1"), RaftMember.Type.ACTIVE, Instant.now());
        List<DefaultRaftMember> newRemoteMembers = List.of(new DefaultRaftMember(new MemberId("2"), RaftMember.Type.ACTIVE, Instant.now()), new DefaultRaftMember(new MemberId("3"), RaftMember.Type.ACTIVE, Instant.now()));
        List<DefaultRaftMember> newMembers = Stream.concat(Stream.of(localMember), newRemoteMembers.stream()).toList();
        List<DefaultRaftMember> oldMembers = List.of(localMember);
        RaftContext raft = this.raftWithStoredConfiguration(new Configuration(1L, 1L, Instant.now().toEpochMilli(), newMembers, oldMembers));
        RaftClusterContext context = new RaftClusterContext(localMember.memberId(), raft);
        context.bootstrap(List.of()).join();
        for (RaftMember raftMember : newRemoteMembers) {
            context.getMemberContext(raftMember.memberId()).setMatchIndex(5L);
        }
        Assertions.assertThat((Optional)context.getQuorumFor(RaftMemberContext::getMatchIndex)).hasValue((Object)5L);
    }

    @Test
    void demotedMemberIsNotVoting() {
        DefaultRaftMember localMember = new DefaultRaftMember(new MemberId("1"), RaftMember.Type.ACTIVE, Instant.now());
        Configuration initialConfiguration = new Configuration(1L, 1L, Instant.now().toEpochMilli(), List.of(localMember, new DefaultRaftMember(new MemberId("2"), RaftMember.Type.ACTIVE, Instant.now()), new DefaultRaftMember(new MemberId("3"), RaftMember.Type.ACTIVE, Instant.now())));
        RaftContext raft = this.raftWithStoredConfiguration(initialConfiguration);
        RaftClusterContext context = new RaftClusterContext(localMember.memberId(), raft);
        context.bootstrap(List.of()).join();
        Configuration newConfiguration = new Configuration(2L, 1L, Instant.now().toEpochMilli(), List.of(localMember, new DefaultRaftMember(new MemberId("2"), RaftMember.Type.ACTIVE, Instant.now()), new DefaultRaftMember(new MemberId("3"), RaftMember.Type.PASSIVE, Instant.now())), List.of());
        context.configure(newConfiguration);
        Assertions.assertThat((Collection)context.getVotingMembers()).containsExactly((Object[])new RaftMember[]{new DefaultRaftMember(new MemberId("2"), RaftMember.Type.ACTIVE, Instant.now())});
    }

    @Test
    void shouldKeepMembersWithHighestType() {
        DefaultRaftMember localMember = new DefaultRaftMember(new MemberId("1"), RaftMember.Type.ACTIVE, Instant.now());
        Configuration initialConfiguration = new Configuration(1L, 1L, Instant.now().toEpochMilli(), List.of(localMember, new DefaultRaftMember(new MemberId("2"), RaftMember.Type.ACTIVE, Instant.now()), new DefaultRaftMember(new MemberId("3"), RaftMember.Type.ACTIVE, Instant.now())));
        RaftContext raft = this.raftWithStoredConfiguration(initialConfiguration);
        RaftClusterContext context = new RaftClusterContext(localMember.memberId(), raft);
        context.bootstrap(List.of()).join();
        Configuration newConfiguration = new Configuration(2L, 1L, Instant.now().toEpochMilli(), List.of(localMember, new DefaultRaftMember(new MemberId("2"), RaftMember.Type.ACTIVE, Instant.now()), new DefaultRaftMember(new MemberId("3"), RaftMember.Type.PASSIVE, Instant.now())), List.of());
        context.configure(newConfiguration);
        Assertions.assertThat((Collection)context.getConfiguration().allMembers()).containsExactlyInAnyOrder((Object[])new RaftMember[]{localMember, new DefaultRaftMember(new MemberId("2"), RaftMember.Type.ACTIVE, Instant.now()), new DefaultRaftMember(new MemberId("3"), RaftMember.Type.ACTIVE, Instant.now())});
    }

    private RaftContext raftWithStoredConfiguration(Configuration configuration) {
        ThreadContext threadContext = new ThreadContext(this){

            public Scheduled schedule(Duration initialDelay, Duration interval, Runnable callback) {
                throw new UnsupportedOperationException();
            }

            public void execute(Runnable command) {
                command.run();
            }
        };
        RaftContext raft = (RaftContext)Mockito.mock(RaftContext.class, (MockSettings)Mockito.withSettings().stubOnly());
        MetaStore metaStore = (MetaStore)Mockito.mock(MetaStore.class, (MockSettings)Mockito.withSettings().stubOnly());
        Mockito.when((Object)raft.getThreadContext()).thenReturn((Object)threadContext);
        Mockito.when((Object)metaStore.loadConfiguration()).thenReturn((Object)configuration);
        Mockito.when((Object)raft.getMetaStore()).thenReturn((Object)metaStore);
        return raft;
    }
}

