/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft;

import io.atomix.raft.RaftRule;
import io.atomix.raft.RaftServer;
import io.atomix.raft.SnapshotReplicationListener;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class SnapshotReplicationListenerTest {
    @Rule
    public RaftRule raftRule = RaftRule.withBootstrappedNodes(3);

    @Test
    public void shouldNotifySnapshotReplicationListener() throws Throwable {
        SnapshotReplicationListener snapshotReplicationListener = (SnapshotReplicationListener)Mockito.mock(SnapshotReplicationListener.class);
        RaftServer follower = this.raftRule.getFollower().orElseThrow();
        follower.getContext().addSnapshotReplicationListener(snapshotReplicationListener);
        this.raftRule.partition(follower);
        RaftServer leader = this.raftRule.getLeader().orElseThrow();
        leader.getContext().setPreferSnapshotReplicationThreshold(1);
        long commitIndex = this.raftRule.appendEntries(2);
        this.raftRule.takeSnapshot(leader, commitIndex, 1);
        this.raftRule.appendEntry();
        CountDownLatch snapshotReceived = new CountDownLatch(1);
        this.raftRule.getPersistedSnapshotStore(follower.name()).addSnapshotListener(s -> snapshotReceived.countDown());
        this.raftRule.reconnect(follower);
        Assertions.assertThat((boolean)snapshotReceived.await(30L, TimeUnit.SECONDS)).isTrue();
        ((SnapshotReplicationListener)Mockito.verify((Object)snapshotReplicationListener, (VerificationMode)Mockito.timeout((long)1000L).times(1))).onSnapshotReplicationStarted();
        ((SnapshotReplicationListener)Mockito.verify((Object)snapshotReplicationListener, (VerificationMode)Mockito.timeout((long)1000L).times(1))).onSnapshotReplicationCompleted(follower.getTerm());
    }

    @Test
    public void shouldCallStartedOnRegister() {
        SnapshotReplicationListener snapshotReplicationListener = (SnapshotReplicationListener)Mockito.mock(SnapshotReplicationListener.class);
        RaftServer follower = this.raftRule.getFollower().orElseThrow();
        follower.getContext().notifySnapshotReplicationStarted();
        follower.getContext().addSnapshotReplicationListener(snapshotReplicationListener);
        ((SnapshotReplicationListener)Mockito.verify((Object)snapshotReplicationListener, (VerificationMode)Mockito.timeout((long)1000L).times(1))).onSnapshotReplicationStarted();
    }

    @Test
    public void shouldCallStartedAndCompletedOnRegister() {
        SnapshotReplicationListener snapshotReplicationListener = (SnapshotReplicationListener)Mockito.mock(SnapshotReplicationListener.class);
        RaftServer follower = this.raftRule.getFollower().orElseThrow();
        follower.getContext().notifySnapshotReplicationStarted();
        follower.getContext().notifySnapshotReplicationCompleted();
        follower.getContext().addSnapshotReplicationListener(snapshotReplicationListener);
        ((SnapshotReplicationListener)Mockito.verify((Object)snapshotReplicationListener, (VerificationMode)Mockito.timeout((long)1000L).times(1))).onSnapshotReplicationStarted();
        ((SnapshotReplicationListener)Mockito.verify((Object)snapshotReplicationListener, (VerificationMode)Mockito.timeout((long)1000L).times(1))).onSnapshotReplicationCompleted(follower.getTerm());
    }

    @Test
    public void shouldNotCallListenerOnRegister() {
        SnapshotReplicationListener snapshotReplicationListener = (SnapshotReplicationListener)Mockito.mock(SnapshotReplicationListener.class);
        RaftServer follower = this.raftRule.getFollower().orElseThrow();
        follower.getContext().addSnapshotReplicationListener(snapshotReplicationListener);
        ((SnapshotReplicationListener)Mockito.verify((Object)snapshotReplicationListener, (VerificationMode)Mockito.times((int)0))).onSnapshotReplicationStarted();
        ((SnapshotReplicationListener)Mockito.verify((Object)snapshotReplicationListener, (VerificationMode)Mockito.times((int)0))).onSnapshotReplicationCompleted(follower.getTerm());
    }

    @Test
    public void shouldNotCallListenerOnRegisterIfLeader() {
        SnapshotReplicationListener snapshotReplicationListener = (SnapshotReplicationListener)Mockito.mock(SnapshotReplicationListener.class);
        RaftServer leader = this.raftRule.getLeader().orElseThrow();
        leader.getContext().notifySnapshotReplicationStarted();
        leader.getContext().notifySnapshotReplicationCompleted();
        leader.getContext().addSnapshotReplicationListener(snapshotReplicationListener);
        ((SnapshotReplicationListener)Mockito.verify((Object)snapshotReplicationListener, (VerificationMode)Mockito.times((int)0))).onSnapshotReplicationStarted();
        ((SnapshotReplicationListener)Mockito.verify((Object)snapshotReplicationListener, (VerificationMode)Mockito.times((int)0))).onSnapshotReplicationCompleted(leader.getTerm());
    }
}

