/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft;

import io.atomix.cluster.MemberId;
import io.atomix.raft.RaftRule;
import io.atomix.raft.RaftServer;
import io.atomix.raft.protocol.InstallRequest;
import io.atomix.raft.protocol.TestRaftServerProtocol;
import io.atomix.raft.snapshot.TestSnapshotStore;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.agrona.LangUtil;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.NotThrownAssert;
import org.awaitility.Awaitility;
import org.junit.Rule;
import org.junit.Test;

public class RaftStartupConsistencyCheckTest {
    @Rule
    public RaftRule raftRule = RaftRule.withBootstrappedNodes(3);

    @Test
    public void shouldNotFailRestartIfFollowerCrashedBeforeCommittingSnapshot() throws Exception {
        RaftServer followerToRestart = this.raftRule.getFollower().orElseThrow();
        this.raftRule.partition(followerToRestart);
        long commitIndex = this.raftRule.appendEntries(10);
        RaftServer leader = this.raftRule.getLeader().orElseThrow();
        leader.getContext().setPreferSnapshotReplicationThreshold(1);
        long snapshotIndex = commitIndex - 1L;
        this.raftRule.takeSnapshot(leader, snapshotIndex, 1);
        TestSnapshotStore testSnapshotStore = (TestSnapshotStore)followerToRestart.getContext().getPersistedSnapshotStore();
        CompletableFuture followerCrashed = new CompletableFuture();
        testSnapshotStore.interceptOnNewSnapshot(() -> {
            try {
                ((CompletableFuture)followerToRestart.shutdown().thenApply(r -> followerCrashed.complete(null))).exceptionally(followerCrashed::completeExceptionally);
                throw new RuntimeException("Error");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        this.raftRule.reconnect(followerToRestart);
        followerCrashed.join();
        String followerId = (String)((Object)followerToRestart.cluster().getLocalMember().memberId().id());
        ((NotThrownAssert)Assertions.assertThatNoException().describedAs("Consistency check on startup does not fail.", new Object[0])).isThrownBy(() -> this.raftRule.joinCluster(followerId));
        Awaitility.await((String)"Restarted follower has received new snapshot").untilAsserted(() -> Assertions.assertThat((long)this.raftRule.getPersistedSnapshotStore(followerId).getCurrentSnapshotIndex()).isEqualTo(snapshotIndex));
    }

    @Test
    public void shouldHandleRetriedRequestsAfterSnapshotPersist() throws Exception {
        final AtomicBoolean snapshotPersistCalled = new AtomicBoolean();
        final CountDownLatch retryBarrier = new CountDownLatch(1);
        RaftServer leader = this.raftRule.getLeader().orElseThrow();
        RaftServer follower = this.raftRule.getFollower().orElseThrow();
        this.raftRule.shutdownServer(follower);
        long snapshotIndex = this.raftRule.appendEntries(500);
        this.raftRule.takeCompactingSnapshot(leader, snapshotIndex - 1L, 3);
        long lastIndex = this.raftRule.appendEntries(10);
        leader.getContext().setPreferSnapshotReplicationThreshold(1);
        final Runnable interceptor = () -> {
            try {
                snapshotPersistCalled.set(true);
                retryBarrier.await();
            }
            catch (InterruptedException e) {
                LangUtil.rethrowUnchecked((Throwable)e);
            }
        };
        this.raftRule.bootstrapNode(follower.name(), new RaftRule.Configurator(){

            @Override
            public void configure(MemberId id, RaftServer.Builder builder) {
                TestRaftServerProtocol protocol = (TestRaftServerProtocol)builder.protocol;
                protocol.interceptRequest(InstallRequest.class, r -> {
                    if (snapshotPersistCalled.get()) {
                        retryBarrier.countDown();
                    }
                });
            }

            @Override
            public void configure(TestSnapshotStore snapshotStore) {
                snapshotStore.interceptOnNewSnapshot(interceptor);
            }
        });
        this.raftRule.allNodesHaveSnapshotWithIndex(snapshotIndex);
        this.raftRule.awaitSameLogSizeOnAllNodes(lastIndex);
    }
}

