/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft;

import io.atomix.cluster.MemberId;
import io.atomix.raft.ControllableRaftContexts;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;

public final class RaftOperation {
    private final BiConsumer<ControllableRaftContexts, MemberId> operation;
    private final String name;

    private RaftOperation(String name, BiConsumer<ControllableRaftContexts, MemberId> operation) {
        this.name = name;
        this.operation = operation;
    }

    public static RaftOperation of(String name, BiConsumer<ControllableRaftContexts, MemberId> operation) {
        return new RaftOperation(name, operation);
    }

    public void run(ControllableRaftContexts raftContext, MemberId memberId) {
        this.operation.accept(raftContext, memberId);
    }

    public String toString() {
        return this.name;
    }

    public static List<RaftOperation> getRaftOperationsWithSnapshot() {
        List<RaftOperation> defaultRaftOperation = RaftOperation.getDefaultRaftOperations();
        defaultRaftOperation.add(RaftOperation.of("Take snapshot", ControllableRaftContexts::snapshotAndCompact));
        return defaultRaftOperation;
    }

    public static List<RaftOperation> getRaftOperationsWithRestarts() {
        List<RaftOperation> defaultRaftOperation = RaftOperation.getDefaultRaftOperations();
        defaultRaftOperation.add(RaftOperation.of("Restart member", ControllableRaftContexts::restart));
        return defaultRaftOperation;
    }

    public static List<RaftOperation> getRaftOperationsWithSnapshotsAndRestarts() {
        List<RaftOperation> operationsWithSnapshot = RaftOperation.getRaftOperationsWithSnapshot();
        operationsWithSnapshot.add(RaftOperation.of("Restart member", ControllableRaftContexts::restart));
        return operationsWithSnapshot;
    }

    public static List<RaftOperation> getRaftOperationsWithSnapshotsAndRestartsWithDataLoss() {
        List<RaftOperation> operations = RaftOperation.getRaftOperationsWithSnapshotsAndRestarts();
        operations.add(RaftOperation.of("Restart member with full data loss", ControllableRaftContexts::restartWithDataLoss));
        return operations;
    }

    public static List<RaftOperation> getDefaultRaftOperations() {
        ArrayList<RaftOperation> defaultRaftOperation = new ArrayList<RaftOperation>();
        defaultRaftOperation.add(RaftOperation.of("Run next task", ControllableRaftContexts::runNextTask));
        defaultRaftOperation.add(RaftOperation.of("Receive next message", ControllableRaftContexts::processNextMessage));
        defaultRaftOperation.add(RaftOperation.of("Tick electionTimeout", ControllableRaftContexts::tickElectionTimeout));
        defaultRaftOperation.add(RaftOperation.of("Tick heartbeatTimeout", ControllableRaftContexts::tickHeartbeatTimeout));
        defaultRaftOperation.add(RaftOperation.of("Tick 50ms", (raftContexts, m) -> raftContexts.tick((MemberId)m, Duration.ofMillis(50L))));
        defaultRaftOperation.add(RaftOperation.of("Append on leader", (raftContexts, m) -> raftContexts.clientAppendOnLeader()));
        defaultRaftOperation.add(RaftOperation.of("Drop next message", (raftContexts, m) -> raftContexts.getServerProtocol((MemberId)m).dropNextMessage()));
        return defaultRaftOperation;
    }
}

