/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft;

import io.atomix.utils.concurrent.Scheduled;
import io.atomix.utils.concurrent.ScheduledFutureImpl;
import io.atomix.utils.concurrent.ThreadContext;
import java.time.Duration;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jmock.lib.concurrent.DeterministicScheduler;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DeterministicSingleThreadContext
implements ThreadContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeterministicSingleThreadContext.class);
    private final DeterministicScheduler deterministicScheduler;

    public DeterministicSingleThreadContext(DeterministicScheduler executor) {
        this.deterministicScheduler = executor;
    }

    public DeterministicScheduler getDeterministicScheduler() {
        return this.deterministicScheduler;
    }

    public static ThreadContext createContext() {
        return new DeterministicSingleThreadContext(new DeterministicScheduler());
    }

    public Scheduled schedule(long delay, TimeUnit timeUnit, Runnable command) {
        ScheduledFuture future = this.deterministicScheduler.schedule((Runnable)new WrappedRunnable(command), delay, timeUnit);
        return new ScheduledFutureImpl((Future)future);
    }

    public Scheduled schedule(Duration delay, Runnable command) {
        ScheduledFuture future = this.deterministicScheduler.schedule((Runnable)new WrappedRunnable(command), delay.toMillis(), TimeUnit.MILLISECONDS);
        return new ScheduledFutureImpl((Future)future);
    }

    public Scheduled schedule(long initialDelay, long interval, TimeUnit timeUnit, Runnable command) {
        ScheduledFuture future = this.deterministicScheduler.scheduleAtFixedRate((Runnable)new WrappedRunnable(command), initialDelay, interval, timeUnit);
        return new ScheduledFutureImpl((Future)future);
    }

    public Scheduled schedule(Duration initialDelay, Duration interval, Runnable command) {
        ScheduledFuture future = this.deterministicScheduler.scheduleAtFixedRate((Runnable)new WrappedRunnable(command), initialDelay.toMillis(), interval.toMillis(), TimeUnit.MILLISECONDS);
        return new ScheduledFutureImpl((Future)future);
    }

    public void execute(Runnable command) {
        this.deterministicScheduler.execute((Runnable)new WrappedRunnable(command));
    }

    public void checkThread() {
    }

    public void close() {
    }

    static final class WrappedRunnable
    implements Runnable {
        private final Runnable command;

        WrappedRunnable(Runnable command) {
            this.command = command;
        }

        @Override
        public void run() {
            try {
                this.command.run();
            }
            catch (Exception e) {
                LOGGER.error("Uncaught exception", (Throwable)e);
                Assert.fail((String)("Uncaught exception" + String.valueOf(e)));
            }
        }
    }
}

