/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.storage.log.entry;

import io.atomix.raft.cluster.RaftMember;
import io.atomix.raft.storage.log.entry.RaftEntry;
import io.atomix.raft.storage.serializer.RaftEntrySerializer;
import io.camunda.zeebe.util.buffer.BufferWriter;
import io.netty.util.internal.ObjectUtil;
import java.util.Collection;
import java.util.Collections;
import org.agrona.MutableDirectBuffer;

public record ConfigurationEntry(long timestamp, Collection<RaftMember> newMembers, Collection<RaftMember> oldMembers) implements RaftEntry
{
    public ConfigurationEntry {
        ObjectUtil.checkNotNull(newMembers, (String)"newMembers cannot be null");
        ObjectUtil.checkNotNull(oldMembers, (String)"oldMembers cannot be null");
    }

    public ConfigurationEntry(long timestamp, Collection<RaftMember> newMembers) {
        this(timestamp, newMembers, Collections.emptyList());
    }

    public boolean requiresJointConsensus() {
        return !this.oldMembers.isEmpty();
    }

    @Override
    public BufferWriter toSerializable(long term, RaftEntrySerializer serializer) {
        return new RaftEntrySerializer.SerializedBufferWriterAdapter(() -> serializer.getConfigurationEntrySerializedLength(this), (buffer, offset) -> serializer.writeConfigurationEntry(term, this, (MutableDirectBuffer)buffer, (int)offset));
    }
}

