/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.storage;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.raft.storage.StorageException;
import io.atomix.raft.storage.log.RaftLog;
import io.atomix.raft.storage.log.RaftLogFlusher;
import io.atomix.raft.storage.system.MetaStore;
import io.atomix.utils.concurrent.ThreadContextFactory;
import io.camunda.zeebe.snapshots.ReceivableSnapshotStore;
import io.camunda.zeebe.util.FileUtil;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.Objects;

public final class RaftStorage {
    private final String prefix;
    private final int partitionId;
    private final File directory;
    private final int maxSegmentSize;
    private final long freeDiskSpace;
    private final ReceivableSnapshotStore persistedSnapshotStore;
    private final int journalIndexDensity;
    private final boolean preallocateSegmentFiles;
    private final MeterRegistry meterRegistry;
    private final RaftLogFlusher.Factory flusherFactory;

    private RaftStorage(String prefix, int partitionId, File directory, int maxSegmentSize, long freeDiskSpace, RaftLogFlusher.Factory flusherFactory, ReceivableSnapshotStore persistedSnapshotStore, int journalIndexDensity, boolean preallocateSegmentFiles, MeterRegistry meterRegistry) {
        this.prefix = prefix;
        this.partitionId = partitionId;
        this.directory = directory;
        this.maxSegmentSize = maxSegmentSize;
        this.freeDiskSpace = freeDiskSpace;
        this.flusherFactory = flusherFactory;
        this.persistedSnapshotStore = persistedSnapshotStore;
        this.journalIndexDensity = journalIndexDensity;
        this.preallocateSegmentFiles = preallocateSegmentFiles;
        this.meterRegistry = meterRegistry;
        try {
            FileUtil.ensureDirectoryExists((Path)directory.toPath());
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to create partition's directory %s", directory.toPath()), e);
        }
    }

    public static Builder builder(MeterRegistry meterRegistry) {
        return new Builder(meterRegistry);
    }

    public String prefix() {
        return this.prefix;
    }

    public boolean lock(String id) {
        File lockFile = new File(this.directory, String.format(".%s.lock", this.prefix));
        File tempLockFile = new File(this.directory, String.format(".%s.lock.tmp", id));
        try {
            String lock;
            if (!lockFile.exists()) {
                Files.writeString(tempLockFile.toPath(), (CharSequence)id, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE, StandardOpenOption.SYNC);
                FileUtil.moveDurably((Path)tempLockFile.toPath(), (Path)lockFile.toPath(), (CopyOption[])new CopyOption[]{StandardCopyOption.ATOMIC_MOVE});
            }
            return (lock = Files.readString(lockFile.toPath())) != null && lock.equals(id);
        }
        catch (FileAlreadyExistsException e) {
            return false;
        }
        catch (IOException e) {
            throw new StorageException("Failed to acquire storage lock", e);
        }
    }

    public MetaStore openMetaStore() {
        try {
            return new MetaStore(this, this.meterRegistry);
        }
        catch (IOException e) {
            throw new StorageException("Failed to open metastore", e);
        }
    }

    public ReceivableSnapshotStore getPersistedSnapshotStore() {
        return this.persistedSnapshotStore;
    }

    public RaftLog openLog(MetaStore metaStore, ThreadContextFactory threadFactory) {
        return RaftLog.builder(this.meterRegistry).withName(this.prefix).withPartitionId(this.partitionId).withDirectory(this.directory).withMaxSegmentSize(this.maxSegmentSize).withFreeDiskSpace(this.freeDiskSpace).withJournalIndexDensity(this.journalIndexDensity).withPreallocateSegmentFiles(this.preallocateSegmentFiles).withMetaStore(metaStore).withFlusher(this.flusherFactory.createFlusher(threadFactory)).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("directory", (Object)this.directory()).toString();
    }

    public File directory() {
        return this.directory;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public static final class Builder
    implements io.atomix.utils.Builder<RaftStorage> {
        private static final String DEFAULT_PREFIX = "atomix";
        private static final String DEFAULT_DIRECTORY = System.getProperty("atomix.data", System.getProperty("user.dir"));
        private static final int DEFAULT_MAX_SEGMENT_SIZE = 0x2000000;
        private static final long DEFAULT_FREE_DISK_SPACE = 0x40000000L;
        private static final RaftLogFlusher.Factory DEFAULT_FLUSHER_FACTORY = RaftLogFlusher.Factory::direct;
        private static final int DEFAULT_JOURNAL_INDEX_DENSITY = 100;
        private static final boolean DEFAULT_PREALLOCATE_SEGMENT_FILES = true;
        private static final int DEFAULT_PARTITION_ID = -1;
        private String prefix = "atomix";
        private File directory = new File(DEFAULT_DIRECTORY);
        private int maxSegmentSize = 0x2000000;
        private long freeDiskSpace = 0x40000000L;
        private RaftLogFlusher.Factory flusherFactory = DEFAULT_FLUSHER_FACTORY;
        private ReceivableSnapshotStore persistedSnapshotStore;
        private int journalIndexDensity = 100;
        private boolean preallocateSegmentFiles = true;
        private int partitionId = -1;
        private final MeterRegistry meterRegistry;

        private Builder(MeterRegistry meterRegistry) {
            this.meterRegistry = Objects.requireNonNull(meterRegistry, "meterRegistry cannot be null");
        }

        public Builder withPrefix(String prefix) {
            this.prefix = (String)Preconditions.checkNotNull((Object)prefix, (Object)"prefix cannot be null");
            return this;
        }

        public Builder withDirectory(File directory) {
            this.directory = (File)Preconditions.checkNotNull((Object)directory, (Object)"directory");
            return this;
        }

        public Builder withMaxSegmentSize(int maxSegmentSize) {
            this.maxSegmentSize = maxSegmentSize;
            return this;
        }

        public Builder withFreeDiskSpace(long freeDiskSpace) {
            Preconditions.checkArgument((freeDiskSpace >= 0L ? 1 : 0) != 0, (Object)"freeDiskSpace must be positive");
            this.freeDiskSpace = freeDiskSpace;
            return this;
        }

        public Builder withFlusherFactory(RaftLogFlusher.Factory flusherFactory) {
            this.flusherFactory = flusherFactory;
            return this;
        }

        public Builder withSnapshotStore(ReceivableSnapshotStore persistedSnapshotStore) {
            this.persistedSnapshotStore = persistedSnapshotStore;
            return this;
        }

        public Builder withJournalIndexDensity(int journalIndexDensity) {
            this.journalIndexDensity = journalIndexDensity;
            return this;
        }

        public Builder withPreallocateSegmentFiles(boolean preallocateSegmentFiles) {
            this.preallocateSegmentFiles = preallocateSegmentFiles;
            return this;
        }

        public Builder withPartitionId(int partitionId) {
            this.partitionId = partitionId;
            return this;
        }

        public RaftStorage build() {
            return new RaftStorage(this.prefix, this.partitionId, this.directory, this.maxSegmentSize, this.freeDiskSpace, this.flusherFactory, this.persistedSnapshotStore, this.journalIndexDensity, this.preallocateSegmentFiles, this.meterRegistry);
        }
    }
}

