/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.roles;

import com.google.common.base.MoreObjects;
import io.atomix.cluster.MemberId;
import io.atomix.raft.RaftError;
import io.atomix.raft.RaftException;
import io.atomix.raft.cluster.impl.DefaultRaftMember;
import io.atomix.raft.impl.RaftContext;
import io.atomix.raft.protocol.RaftRequest;
import io.atomix.raft.protocol.RaftResponse;
import io.atomix.raft.roles.RaftRole;
import io.camunda.zeebe.util.Either;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRole
implements RaftRole {
    protected final Logger log;
    protected final RaftContext raft;
    private volatile boolean open = true;

    protected AbstractRole(RaftContext raft) {
        this.raft = raft;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    @Override
    public Either<RaftError, Void> shouldAcceptRequest(RaftRequest request) {
        boolean shouldReject;
        boolean bl = shouldReject = this.raft.getCluster().getConfiguration() != null && this.raft.getCluster().getConfiguration().force() && !this.raft.getCluster().getConfiguration().hasMember(request.from());
        if (shouldReject) {
            return Either.left((Object)new RaftError(RaftError.Type.ILLEGAL_MEMBER_STATE, String.format("Force configuration change is in progress. Cannot accept request from %s which is not a member of the new configuration.", request.from())));
        }
        return Either.right(null);
    }

    protected final void logRequest(Object request) {
        this.log.trace("Received {}", request);
    }

    protected final <R extends RaftResponse> R logResponse(R response) {
        this.log.trace("Sending {}", response);
        return response;
    }

    public CompletableFuture<RaftRole> start() {
        this.raft.checkThread();
        this.open = true;
        return CompletableFuture.completedFuture(null);
    }

    public boolean isRunning() {
        return this.open;
    }

    public CompletableFuture<Void> stop() {
        this.raft.checkThread();
        this.open = false;
        return CompletableFuture.completedFuture(null);
    }

    protected <T extends RaftRequest, U extends RaftResponse> CompletableFuture<U> forward(T request, BiFunction<MemberId, T, CompletableFuture<U>> function) {
        CompletableFuture future = new CompletableFuture();
        DefaultRaftMember leader = this.raft.getLeader();
        if (leader == null) {
            return CompletableFuture.failedFuture(new RaftException.NoLeader("No leader found", new Object[0]));
        }
        function.apply(leader.memberId(), (MemberId)((Object)request)).whenCompleteAsync((response, error) -> {
            if (error == null) {
                future.complete(response);
            } else {
                future.completeExceptionally((Throwable)error);
            }
        }, (Executor)this.raft.getThreadContext());
        return future;
    }

    protected boolean updateTermAndLeader(long term, MemberId leader) {
        if (term > this.raft.getTerm() || term == this.raft.getTerm() && this.raft.getLeader() == null && leader != null) {
            this.raft.setTerm(term);
            this.raft.setLeader(leader);
            this.raft.getCluster().reset();
            return true;
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("context", (Object)this.raft).toString();
    }
}

