/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.protocol;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.raft.RaftError;
import io.atomix.raft.protocol.AbstractRaftResponse;
import io.atomix.raft.protocol.RaftResponse;

public class InstallResponse
extends AbstractRaftResponse {
    protected int preferredChunkSize;

    public InstallResponse(RaftResponse.Status status, RaftError error, int preferredChunkSize) {
        super(status, error);
        this.preferredChunkSize = preferredChunkSize;
    }

    public int preferredChunkSize() {
        return this.preferredChunkSize;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("status", (Object)this.status).add("error", (Object)this.error).add("preferredChunkSize", this.preferredChunkSize).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractRaftResponse.Builder<Builder, InstallResponse> {
        protected int preferredChunkSize;

        public InstallResponse build() {
            this.validate();
            Preconditions.checkArgument((this.preferredChunkSize >= 0 ? 1 : 0) != 0, (Object)"preferred chunk size must be positive");
            return new InstallResponse(this.status, this.error, this.preferredChunkSize);
        }

        public Builder withPreferredChunkSize(int preferredChunkSize) {
            this.preferredChunkSize = preferredChunkSize;
            return this;
        }
    }
}

