/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.partition;

public final class RaftElectionConfig {
    private final boolean priorityElectionEnabled;
    private final int initialTargetPriority;
    private int nodePriority;

    private RaftElectionConfig(boolean priorityElectionEnabled, int initialTargetPriority, int nodePriority) {
        this.priorityElectionEnabled = priorityElectionEnabled;
        this.initialTargetPriority = initialTargetPriority;
        this.nodePriority = nodePriority;
    }

    public static RaftElectionConfig ofPriorityElection(int initialTargetPriority, int nodePriority) {
        return new RaftElectionConfig(true, initialTargetPriority, nodePriority);
    }

    public static RaftElectionConfig ofDefaultElection() {
        return new RaftElectionConfig(false, -1, -1);
    }

    public boolean isPriorityElectionEnabled() {
        return this.priorityElectionEnabled;
    }

    public int getInitialTargetPriority() {
        return this.initialTargetPriority;
    }

    public int getNodePriority() {
        return this.nodePriority;
    }

    public void setNodePriority(int nodePriority) {
        this.nodePriority = nodePriority;
    }
}

