/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.impl;

import com.google.common.base.Preconditions;
import io.atomix.cluster.BootstrapService;
import io.atomix.cluster.ClusterMembershipEvent;
import io.atomix.cluster.ClusterMembershipEventListener;
import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.ManagedClusterMembershipService;
import io.atomix.cluster.Member;
import io.atomix.cluster.MemberId;
import io.atomix.cluster.discovery.ManagedNodeDiscoveryService;
import io.atomix.cluster.impl.StatefulMember;
import io.atomix.cluster.protocol.GroupMembershipEvent;
import io.atomix.cluster.protocol.GroupMembershipEventListener;
import io.atomix.cluster.protocol.GroupMembershipProtocol;
import io.atomix.utils.Version;
import io.atomix.utils.event.AbstractListenerManager;
import io.atomix.utils.event.Event;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClusterMembershipService
extends AbstractListenerManager<ClusterMembershipEvent, ClusterMembershipEventListener>
implements ManagedClusterMembershipService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultClusterMembershipService.class);
    private final ManagedNodeDiscoveryService discoveryService;
    private final BootstrapService bootstrapService;
    private final GroupMembershipProtocol protocol;
    private final StatefulMember localMember;
    private final AtomicBoolean started = new AtomicBoolean();
    private final GroupMembershipEventListener membershipEventListener = this::handleMembershipEvent;

    public DefaultClusterMembershipService(Member localMember, Version version, ManagedNodeDiscoveryService discoveryService, BootstrapService bootstrapService, GroupMembershipProtocol protocol) {
        this.discoveryService = (ManagedNodeDiscoveryService)Preconditions.checkNotNull((Object)discoveryService, (Object)"discoveryService cannot be null");
        this.bootstrapService = (BootstrapService)Preconditions.checkNotNull((Object)bootstrapService, (Object)"bootstrapService cannot be null");
        this.protocol = (GroupMembershipProtocol)Preconditions.checkNotNull((Object)protocol, (Object)"protocol cannot be null");
        this.localMember = new StatefulMember(localMember, version);
    }

    @Override
    public Member getLocalMember() {
        return this.localMember;
    }

    @Override
    public Set<Member> getMembers() {
        return this.protocol.getMembers();
    }

    @Override
    public Member getMember(MemberId memberId) {
        return this.protocol.getMember(memberId);
    }

    public CompletableFuture<ClusterMembershipService> start() {
        if (this.started.compareAndSet(false, true)) {
            this.protocol.addListener(this.membershipEventListener);
            return ((CompletableFuture)this.discoveryService.start().thenCompose(v -> {
                this.localMember.setActive(true);
                this.localMember.setReachable(true);
                return this.protocol.join(this.bootstrapService, this.discoveryService, this.localMember);
            })).thenApply(v -> {
                LOGGER.info("Started cluster membership service for member {}", (Object)this.localMember);
                return this;
            });
        }
        return CompletableFuture.completedFuture(null);
    }

    public boolean isRunning() {
        return this.started.get();
    }

    public CompletableFuture<Void> stop() {
        if (this.started.compareAndSet(true, false)) {
            return ((CompletableFuture)this.protocol.leave(this.localMember).thenCompose(v -> this.discoveryService.stop())).thenRun(() -> {
                this.localMember.setActive(false);
                this.localMember.setReachable(false);
                this.protocol.removeListener(this.membershipEventListener);
                LOGGER.info("Stopped cluster membership service for member {}", (Object)this.localMember);
            });
        }
        return CompletableFuture.completedFuture(null);
    }

    private void handleMembershipEvent(GroupMembershipEvent event) {
        this.post((Event)new ClusterMembershipEvent(ClusterMembershipEvent.Type.valueOf(((GroupMembershipEvent.Type)event.type()).name()), event.member(), event.time()));
    }
}

