/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.protocol;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.cluster.MemberId;
import io.atomix.raft.protocol.AbstractRaftRequest;

public class VoteRequest
extends AbstractRaftRequest {
    private final long term;
    private final String candidate;
    private final long lastLogIndex;
    private final long lastLogTerm;

    public VoteRequest(long term, String candidate, long lastLogIndex, long lastLogTerm) {
        this.term = term;
        this.candidate = candidate;
        this.lastLogIndex = lastLogIndex;
        this.lastLogTerm = lastLogTerm;
    }

    public static Builder builder() {
        return new Builder();
    }

    public long term() {
        return this.term;
    }

    public MemberId candidate() {
        return MemberId.from(this.candidate);
    }

    public long lastLogIndex() {
        return this.lastLogIndex;
    }

    public long lastLogTerm() {
        return this.lastLogTerm;
    }

    public int hashCode() {
        int result = (int)(this.term ^ this.term >>> 32);
        result = 31 * result + this.candidate.hashCode();
        result = 31 * result + (int)(this.lastLogIndex ^ this.lastLogIndex >>> 32);
        result = 31 * result + (int)(this.lastLogTerm ^ this.lastLogTerm >>> 32);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VoteRequest that = (VoteRequest)o;
        if (this.term != that.term) {
            return false;
        }
        if (this.lastLogIndex != that.lastLogIndex) {
            return false;
        }
        if (this.lastLogTerm != that.lastLogTerm) {
            return false;
        }
        return this.candidate.equals(that.candidate);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("term", this.term).add("candidate", (Object)this.candidate).add("lastLogIndex", this.lastLogIndex).add("lastLogTerm", this.lastLogTerm).toString();
    }

    @Override
    public MemberId from() {
        return this.candidate();
    }

    public static class Builder
    extends AbstractRaftRequest.Builder<Builder, VoteRequest> {
        private long term = -1L;
        private String candidate;
        private long lastLogIndex = -1L;
        private long lastLogTerm = -1L;

        public Builder withTerm(long term) {
            Preconditions.checkArgument((term >= 0L ? 1 : 0) != 0, (Object)"term must be positive");
            this.term = term;
            return this;
        }

        public Builder withCandidate(MemberId candidate) {
            this.candidate = (String)((Object)((MemberId)Preconditions.checkNotNull((Object)candidate, (Object)"candidate cannot be null")).id());
            return this;
        }

        public Builder withLastLogIndex(long logIndex) {
            Preconditions.checkArgument((logIndex >= 0L ? 1 : 0) != 0, (Object)"lastLogIndex must be positive");
            this.lastLogIndex = logIndex;
            return this;
        }

        public Builder withLastLogTerm(long logTerm) {
            Preconditions.checkArgument((logTerm >= 0L ? 1 : 0) != 0, (Object)"lastLogTerm must be positive");
            this.lastLogTerm = logTerm;
            return this;
        }

        public VoteRequest build() {
            this.validate();
            return new VoteRequest(this.term, this.candidate, this.lastLogIndex, this.lastLogTerm);
        }

        @Override
        protected void validate() {
            super.validate();
            Preconditions.checkArgument((this.term >= 0L ? 1 : 0) != 0, (Object)"term must be positive");
            Preconditions.checkNotNull((Object)this.candidate, (Object)"candidate cannot be null");
            Preconditions.checkArgument((this.lastLogIndex >= 0L ? 1 : 0) != 0, (Object)"lastLogIndex must be positive");
            Preconditions.checkArgument((this.lastLogTerm >= 0L ? 1 : 0) != 0, (Object)"lastLogTerm must be positive");
        }
    }
}

