/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.metrics;

import io.atomix.raft.metrics.RaftMetrics;
import io.atomix.raft.metrics.SnapshotReplicationMetricsDoc;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public class SnapshotReplicationMetrics
extends RaftMetrics {
    private final AtomicLong count;
    private final AtomicLong duration;

    public SnapshotReplicationMetrics(String partitionName, MeterRegistry meterRegistry) {
        super(partitionName);
        Objects.requireNonNull(meterRegistry, "meterRegistry cannot be null");
        this.count = new AtomicLong(0L);
        Gauge.builder((String)SnapshotReplicationMetricsDoc.COUNT.getName(), this.count::get).description(SnapshotReplicationMetricsDoc.COUNT.getDescription()).tags(new String[]{"partitionGroupName", this.partitionGroupName}).register(meterRegistry);
        this.duration = new AtomicLong(0L);
        Gauge.builder((String)SnapshotReplicationMetricsDoc.DURATION.getName(), this.duration::get).description(SnapshotReplicationMetricsDoc.DURATION.getDescription()).tags(new String[]{"partitionGroupName", this.partitionGroupName}).register(meterRegistry);
    }

    public void incrementCount() {
        this.count.incrementAndGet();
    }

    public void decrementCount() {
        this.count.decrementAndGet();
    }

    public void setCount(int value) {
        this.count.set(value);
    }

    public void observeDuration(long durationMillis) {
        this.duration.set(durationMillis);
    }
}

