/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.metrics;

import io.atomix.raft.metrics.RaftKeyNames;
import io.atomix.raft.metrics.RaftMetrics;
import io.atomix.raft.metrics.RaftStartupMetricsDoc;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.concurrent.atomic.AtomicLong;

public class RaftStartupMetrics
extends RaftMetrics {
    private final AtomicLong bootstrapDuration = new AtomicLong(0L);
    private final AtomicLong joinDuration = new AtomicLong(0L);

    public RaftStartupMetrics(String partitionName, MeterRegistry registry) {
        super(partitionName);
        Gauge.builder((String)RaftStartupMetricsDoc.BOOTSTRAP_DURATION.getName(), this.bootstrapDuration::get).description(RaftStartupMetricsDoc.BOOTSTRAP_DURATION.getDescription()).tags(new String[]{RaftKeyNames.PARTITION_GROUP.asString(), this.partitionGroupName}).register(registry);
        Gauge.builder((String)RaftStartupMetricsDoc.JOIN_DURATION.getName(), this.joinDuration::get).description(RaftStartupMetricsDoc.JOIN_DURATION.getDescription()).tags(new String[]{RaftKeyNames.PARTITION_GROUP.asString(), this.partitionGroupName}).register(registry);
    }

    public void observeBootstrapDuration(long durationMillis) {
        this.bootstrapDuration.set(durationMillis);
    }

    public void observeJoinDuration(long durationMillis) {
        this.joinDuration.set(durationMillis);
    }
}

