/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.metrics;

import io.atomix.raft.metrics.RaftKeyNames;
import io.atomix.raft.metrics.RaftMetrics;
import io.atomix.raft.metrics.RaftRoleMetricsDoc;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class RaftRoleMetrics
extends RaftMetrics {
    private final Counter heartbeatMiss;
    private final Timer heartbeatTime;
    private final AtomicInteger roleValue = new AtomicInteger(0);
    private final AtomicLong electionLatencyValue = new AtomicLong(0L);

    public RaftRoleMetrics(String partitionName, MeterRegistry registry) {
        super(partitionName);
        this.heartbeatMiss = Counter.builder((String)RaftRoleMetricsDoc.HEARTBEAT_MISS.getName()).description(RaftRoleMetricsDoc.HEARTBEAT_MISS.getDescription()).tags(new String[]{RaftKeyNames.PARTITION_GROUP.asString(), this.partitionGroupName}).register(registry);
        this.heartbeatTime = Timer.builder((String)RaftRoleMetricsDoc.HEARTBEAT_TIME.getName()).description(RaftRoleMetricsDoc.HEARTBEAT_TIME.getDescription()).serviceLevelObjectives(RaftRoleMetricsDoc.HEARTBEAT_TIME.getTimerSLOs()).tags(new String[]{RaftKeyNames.PARTITION_GROUP.asString(), this.partitionGroupName}).register(registry);
        Gauge.builder((String)RaftRoleMetricsDoc.ROLE.getName(), this.roleValue::get).description(RaftRoleMetricsDoc.ROLE.getDescription()).tags(new String[]{RaftKeyNames.PARTITION_GROUP.asString(), this.partitionGroupName}).register(registry);
        Gauge.builder((String)RaftRoleMetricsDoc.ELECTION_LATENCY.getName(), this.electionLatencyValue::get).description(RaftRoleMetricsDoc.ELECTION_LATENCY.getDescription()).tags(new String[]{RaftKeyNames.PARTITION_GROUP.asString(), partitionName}).register(registry);
    }

    public void becomingInactive() {
        this.roleValue.set(0);
    }

    public void becomingFollower() {
        this.roleValue.set(1);
    }

    public void becomingCandidate() {
        this.roleValue.set(2);
    }

    public void becomingLeader() {
        this.roleValue.set(3);
    }

    public void countHeartbeatMiss() {
        this.heartbeatMiss.increment();
    }

    public void observeHeartbeatInterval(long milliseconds) {
        this.heartbeatTime.record(milliseconds, TimeUnit.MILLISECONDS);
    }

    public double getHeartbeatMissCount() {
        return this.heartbeatMiss.count();
    }

    public void setElectionLatency(long latencyMs) {
        this.electionLatencyValue.set(latencyMs);
    }
}

