/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.metrics;

import io.atomix.raft.metrics.LeaderMetricsDoc;
import io.atomix.raft.metrics.RaftKeyNames;
import io.atomix.raft.metrics.RaftMetrics;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class LeaderMetrics
extends RaftMetrics {
    private final MeterRegistry meterRegistry;
    private final Map<String, Timer> appendLatency;
    private final Map<String, Counter> appendDataRate;
    private final Map<String, Counter> appendRate;
    private final Counter commitRate;
    private final AtomicLong nonCommittedEntriesValue;
    private final Map<String, AtomicLong> nonReplicatedEntries;

    public LeaderMetrics(String partitionName, MeterRegistry meterRegistry) {
        super(partitionName);
        this.meterRegistry = meterRegistry;
        this.appendLatency = new HashMap<String, Timer>();
        this.appendDataRate = new HashMap<String, Counter>();
        this.appendRate = new HashMap<String, Counter>();
        this.nonReplicatedEntries = new HashMap<String, AtomicLong>();
        this.commitRate = Counter.builder((String)LeaderMetricsDoc.COMMIT_RATE.getName()).description(LeaderMetricsDoc.COMMIT_RATE.getDescription()).tags(new String[]{"partitionGroupName", this.partitionGroupName}).register(meterRegistry);
        this.nonCommittedEntriesValue = new AtomicLong(0L);
        Gauge.builder((String)LeaderMetricsDoc.NON_COMMITTED_ENTRIES.getName(), this.nonCommittedEntriesValue::get).description(LeaderMetricsDoc.NON_COMMITTED_ENTRIES.getDescription()).tags(new String[]{"partitionGroupName", this.partitionGroupName}).register(meterRegistry);
    }

    public void appendComplete(long latencyms, String memberId) {
        this.getAppendLatency(memberId).record(latencyms, TimeUnit.MILLISECONDS);
    }

    public void observeAppend(String memberId, int appendedEntries, int appendedBytes) {
        this.getAppendRate(memberId).increment((double)appendedEntries);
        this.getAppendDataRate(memberId).increment((double)((float)appendedBytes / 1024.0f));
    }

    public void observeCommit() {
        this.commitRate.increment();
    }

    public void observeNonCommittedEntries(long remainingEntries) {
        this.nonCommittedEntriesValue.set(remainingEntries);
    }

    public void observeRemainingEntries(String memberId, long remainingEntries) {
        this.getNonReplicatedEntries(memberId).set(remainingEntries);
    }

    private Timer getAppendLatency(String memberId) {
        return this.appendLatency.computeIfAbsent(memberId, id -> Timer.builder((String)LeaderMetricsDoc.APPEND_ENTRIES_LATENCY.getName()).description(LeaderMetricsDoc.APPEND_ENTRIES_LATENCY.getDescription()).serviceLevelObjectives(LeaderMetricsDoc.APPEND_ENTRIES_LATENCY.getTimerSLOs()).tags(new String[]{RaftKeyNames.FOLLOWER.asString(), memberId, "partitionGroupName", this.partitionGroupName}).register(this.meterRegistry));
    }

    private Counter getAppendDataRate(String memberId) {
        return this.appendDataRate.computeIfAbsent(memberId, id -> Counter.builder((String)LeaderMetricsDoc.APPEND_DATA_RATE.getName()).description(LeaderMetricsDoc.APPEND_DATA_RATE.getDescription()).tags(new String[]{RaftKeyNames.FOLLOWER.asString(), id, "partitionGroupName", this.partitionGroupName}).register(this.meterRegistry));
    }

    private Counter getAppendRate(String memberId) {
        return this.appendRate.computeIfAbsent(memberId, id -> Counter.builder((String)LeaderMetricsDoc.APPEND_RATE.getName()).description(LeaderMetricsDoc.APPEND_RATE.getDescription()).tags(new String[]{RaftKeyNames.FOLLOWER.asString(), id, "partitionGroupName", this.partitionGroupName}).register(this.meterRegistry));
    }

    private AtomicLong getNonReplicatedEntries(String memberId) {
        AtomicLong inMap = this.nonReplicatedEntries.get(memberId);
        if (inMap == null) {
            inMap = new AtomicLong(0L);
            Gauge.builder((String)LeaderMetricsDoc.NON_REPLICATED_ENTRIES.getName(), inMap::get).description(LeaderMetricsDoc.NON_REPLICATED_ENTRIES.getDescription()).tags(new String[]{RaftKeyNames.FOLLOWER.asString(), memberId, "partitionGroupName", this.partitionGroupName}).register(this.meterRegistry);
            this.nonReplicatedEntries.put(memberId, inMap);
        }
        return inMap;
    }
}

