/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging.impl;

import io.atomix.cluster.messaging.impl.AbstractClientConnection;
import io.atomix.cluster.messaging.impl.HandlerRegistry;
import io.atomix.cluster.messaging.impl.LocalServerConnection;
import io.atomix.cluster.messaging.impl.ProtocolRequest;
import java.util.concurrent.CompletableFuture;

final class LocalClientConnection
extends AbstractClientConnection {
    private final LocalServerConnection serverConnection;

    LocalClientConnection(HandlerRegistry handlers) {
        this.serverConnection = new LocalServerConnection(handlers, this);
    }

    @Override
    public CompletableFuture<Void> sendAsync(ProtocolRequest message) {
        this.serverConnection.dispatch(message);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<byte[]> sendAndReceive(ProtocolRequest message) {
        CompletableFuture<byte[]> future = this.awaitResponseForRequestWithId(message.id());
        this.serverConnection.dispatch(message);
        return future;
    }

    @Override
    public void close() {
        super.close();
        this.serverConnection.close();
    }

    public String toString() {
        return "LocalClientConnection{}";
    }
}

