/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.storage;

import io.atomix.raft.storage.RaftStorage;
import io.atomix.raft.storage.log.RaftLogFlusher;
import io.camunda.zeebe.util.FileUtil;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Test;
import org.junit.jupiter.api.AutoClose;

public class RaftStorageTest {
    private static final Path PATH = Paths.get("target/test-logs/", new String[0]);
    @AutoClose
    private final MeterRegistry meterRegistry = new SimpleMeterRegistry();

    @Test
    public void testDefaultConfiguration() {
        RaftStorage storage = RaftStorage.builder((MeterRegistry)this.meterRegistry).build();
        Assertions.assertThat((String)storage.prefix()).isEqualTo("atomix");
        Assertions.assertThat((File)storage.directory()).isEqualTo((Object)new File(System.getProperty("user.dir")));
    }

    @Test
    public void testCustomConfiguration() {
        RaftStorage storage = RaftStorage.builder((MeterRegistry)this.meterRegistry).withPrefix("foo").withDirectory(new File(PATH.toFile(), "foo")).withMaxSegmentSize(0x100000).withFreeDiskSpace(100L).withFlusherFactory(RaftLogFlusher.Factory::noop).build();
        Assertions.assertThat((String)storage.prefix()).isEqualTo("foo");
        Assertions.assertThat((File)storage.directory()).isEqualTo((Object)new File(PATH.toFile(), "foo"));
    }

    @Test
    public void canAcquireLockOnEmptyDirectory() {
        RaftStorage storage1 = RaftStorage.builder((MeterRegistry)this.meterRegistry).withDirectory(PATH.toFile()).withPrefix("test").build();
        Assertions.assertThat((boolean)storage1.lock("a")).isTrue();
    }

    @Test
    public void cannotLockAlreadyLockedDirectory() {
        RaftStorage storage1 = RaftStorage.builder((MeterRegistry)this.meterRegistry).withDirectory(PATH.toFile()).withPrefix("test").build();
        storage1.lock("a");
        RaftStorage storage2 = RaftStorage.builder((MeterRegistry)this.meterRegistry).withDirectory(PATH.toFile()).withPrefix("test").build();
        Assertions.assertThat((boolean)storage2.lock("b")).isFalse();
    }

    @Test
    public void canAcquireLockOnDirectoryLockedBySameNode() {
        RaftStorage storage1 = RaftStorage.builder((MeterRegistry)this.meterRegistry).withDirectory(PATH.toFile()).withPrefix("test").build();
        storage1.lock("a");
        RaftStorage storage3 = RaftStorage.builder((MeterRegistry)this.meterRegistry).withDirectory(PATH.toFile()).withPrefix("test").build();
        Assertions.assertThat((boolean)storage3.lock("a")).isTrue();
    }

    @After
    public void cleanupStorage() throws IOException {
        FileUtil.deleteFolderIfExists((Path)PATH);
    }
}

