/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft;

import io.atomix.cluster.MemberId;
import io.atomix.raft.RaftRule;
import io.atomix.raft.RaftServer;
import io.atomix.raft.partition.RaftElectionConfig;
import io.atomix.raft.storage.RaftStorage;
import io.atomix.raft.storage.log.RaftLogFlusher;
import io.camunda.zeebe.journal.Journal;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.IOException;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.Rule;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaftFlushErrorTest {
    private static final Logger LOG = LoggerFactory.getLogger(RaftFlushErrorTest.class);
    private static final int MEMBERS = 3;
    public AtomicBoolean isFaulty = new AtomicBoolean(false);
    public AtomicInteger flushFailedCount = new AtomicInteger(0);
    @Rule
    public RaftRule raftRule = RaftRule.withBootstrappedNodes(3, new FaultyFlusherConfigurator(1, this.isFaulty::get, this.flushFailedCount::incrementAndGet));

    @Test
    public void shouldAppendEntryOnAllNodesWhenFollowerFailsFlush() throws Throwable {
        RaftServer leader = this.raftRule.getLeader().get();
        boolean failingNodes = true;
        Assertions.assertThat((int)Integer.parseInt(leader.name())).isGreaterThan(1);
        long index = this.raftRule.appendEntry();
        this.raftRule.awaitSameLogSizeOnAllNodes(index);
        LOG.debug("Setting flusher to faulty");
        this.isFaulty.set(true);
        RaftRule.TestAppendListener commitListener = this.raftRule.appendEntryAsync();
        long lastIndex = commitListener.awaitCommit(Duration.ofSeconds(5L));
        Awaitility.await((String)"Flush failed for all faulty nodes at least once").until(() -> this.flushFailedCount.get() > 1);
        this.isFaulty.set(false);
        this.raftRule.awaitSameLogSizeOnAllNodes(lastIndex);
        Assertions.assertThat((int)this.raftRule.getMemberLogs().size()).isEqualTo(3);
        Assertions.assertThat((long)this.raftRule.getServers().stream().filter(s -> s.getRole() == RaftServer.Role.FOLLOWER || s.getRole() == RaftServer.Role.LEADER).count()).isEqualTo(3L);
    }

    private static RaftLogFlusher.Factory faultyFlusher(final Supplier<Boolean> faultyWhen, final Runnable notifyFaultyFlush) {
        return ignored -> new RaftLogFlusher(){

            public void flush(Journal journal) {
                if (((Boolean)faultyWhen.get()).booleanValue()) {
                    notifyFaultyFlush.run();
                    throw new RuntimeException(new IOException("Failed sync"));
                }
                journal.flush();
            }
        };
    }

    private record FaultyFlusherConfigurator(int faultyFlusherNumber, Supplier<Boolean> faultyWhen, Runnable notifyFaultyFlush) implements RaftRule.Configurator
    {
        @Override
        public void configure(MemberId id, RaftServer.Builder builder) {
            int nodePriority;
            int numericId = Integer.parseInt((String)((Object)id.id()));
            if (numericId <= this.faultyFlusherNumber) {
                LOG.trace("failing flusher for member {}", (Object)id);
                RaftStorage storage = builder.storage;
                Objects.requireNonNull(storage);
                builder.withStorage(RaftStorage.builder((MeterRegistry)builder.meterRegistry).withDirectory(storage.directory()).withSnapshotStore(storage.getPersistedSnapshotStore()).withFlusherFactory(RaftFlushErrorTest.faultyFlusher(this.faultyWhen, this.notifyFaultyFlush)).build());
                nodePriority = 1;
            } else {
                LOG.trace("not failing flusher for member {} ", (Object)id);
                nodePriority = 5;
            }
            builder.withElectionConfig(RaftElectionConfig.ofPriorityElection((int)5, (int)nodePriority));
        }
    }
}

