/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.metrics;

import io.atomix.raft.metrics.RaftMetrics;
import io.prometheus.client.Gauge;

public class SnapshotReplicationMetrics
extends RaftMetrics {
    private static final Gauge COUNT = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("atomix")).labelNames(new String[]{"partitionGroupName", "partition"})).help("Count of ongoing snapshot replication")).name("snapshot_replication_count")).register();
    private static final Gauge DURATION = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("atomix")).labelNames(new String[]{"partitionGroupName", "partition"})).help("Approximate duration of replication in milliseconds")).name("snapshot_replication_duration_milliseconds")).register();
    private final Gauge.Child count;
    private final Gauge.Child duration;

    public SnapshotReplicationMetrics(String partitionName) {
        super(partitionName);
        this.count = (Gauge.Child)COUNT.labels(new String[]{this.partitionGroupName, this.partition});
        this.duration = (Gauge.Child)DURATION.labels(new String[]{this.partitionGroupName, this.partition});
    }

    public void incrementCount() {
        this.count.inc();
    }

    public void decrementCount() {
        this.count.dec();
    }

    public void setCount(int value) {
        this.count.set((double)value);
    }

    public void observeDuration(long durationMillis) {
        this.duration.set((double)durationMillis);
    }
}

