/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.atomix.utils.net.Address;
import io.camunda.zeebe.util.collection.Tuple;
import io.netty.channel.Channel;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChannelPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelPool.class);
    private final Function<Address, CompletableFuture<Channel>> factory;
    private final int size;
    private final Map<Tuple<Address, InetAddress>, List<CompletableFuture<Channel>>> channels = Maps.newConcurrentMap();

    ChannelPool(Function<Address, CompletableFuture<Channel>> factory, int size) {
        this.factory = factory;
        this.size = size;
    }

    private List<CompletableFuture<Channel>> getChannelPool(Address address, InetAddress inetAddress) {
        Tuple channelPoolIdentifier = new Tuple((Object)address, (Object)inetAddress);
        List<CompletableFuture<Channel>> channelPool = this.channels.get(channelPoolIdentifier);
        if (channelPool != null) {
            return channelPool;
        }
        return this.channels.computeIfAbsent((Tuple<Address, InetAddress>)channelPoolIdentifier, e -> {
            ArrayList<Object> defaultList = new ArrayList<Object>(this.size);
            for (int i = 0; i < this.size; ++i) {
                defaultList.add(null);
            }
            return Lists.newCopyOnWriteArrayList(defaultList);
        });
    }

    private int getChannelOffset(String messageType) {
        return Math.abs(messageType.hashCode() % this.size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableFuture<Channel> getChannel(Address address, String messageType) {
        CompletableFuture<Channel> finalFuture;
        int offset;
        InetAddress inetAddress = address.getAddress();
        List<CompletableFuture<Channel>> channelPool = this.getChannelPool(address, inetAddress);
        CompletableFuture<Channel> channelFuture = channelPool.get(offset = this.getChannelOffset(messageType));
        if (channelFuture == null || channelFuture.isCompletedExceptionally()) {
            List<CompletableFuture<Channel>> list = channelPool;
            synchronized (list) {
                channelFuture = channelPool.get(offset);
                if (channelFuture == null || channelFuture.isCompletedExceptionally()) {
                    LOGGER.debug("Connecting to {}", (Object)address);
                    finalFuture = channelFuture = this.factory.apply(address);
                    channelFuture.whenComplete((channel, error) -> {
                        if (error == null) {
                            LOGGER.debug("Connected to {}", (Object)channel.remoteAddress());
                            channel.closeFuture().addListener(closed -> {
                                List list = channelPool;
                                synchronized (list) {
                                    ChannelPool.removeChannel(channelPool, offset, finalFuture);
                                }
                            });
                        } else {
                            LOGGER.debug("Failed to connect to {}", (Object)address, error);
                        }
                    });
                    channelPool.set(offset, channelFuture);
                }
            }
        }
        CompletableFuture<Channel> future = new CompletableFuture<Channel>();
        finalFuture = channelFuture;
        finalFuture.whenComplete((channel, error) -> {
            if (error == null) {
                if (!channel.isActive()) {
                    CompletableFuture<Channel> currentFuture;
                    List list = channelPool;
                    synchronized (list) {
                        currentFuture = (CompletableFuture<Channel>)channelPool.get(offset);
                        if (currentFuture == finalFuture) {
                            channelPool.set(offset, null);
                        } else if (currentFuture == null) {
                            currentFuture = this.factory.apply(address);
                            currentFuture.whenComplete(this::logConnection);
                            channelPool.set(offset, currentFuture);
                        }
                    }
                    if (currentFuture == finalFuture) {
                        this.getChannel(address, messageType).whenComplete((recursiveResult, recursiveError) -> this.completeFuture(future, (Channel)recursiveResult, (Throwable)recursiveError));
                    } else {
                        currentFuture.whenComplete((recursiveResult, recursiveError) -> this.completeFuture(future, (Channel)recursiveResult, (Throwable)recursiveError));
                    }
                } else {
                    future.complete((Channel)channel);
                }
            } else {
                future.completeExceptionally((Throwable)error);
            }
        });
        return future;
    }

    private static void removeChannel(List<CompletableFuture<Channel>> channelPool, int offset, CompletableFuture<Channel> finalFuture) {
        CompletableFuture<Channel> currentFuture = channelPool.get(offset);
        if (finalFuture == currentFuture) {
            channelPool.set(offset, null);
        }
    }

    private void completeFuture(CompletableFuture<Channel> future, Channel recursiveResult, Throwable recursiveError) {
        if (recursiveError == null) {
            future.complete(recursiveResult);
        } else {
            future.completeExceptionally(recursiveError);
        }
    }

    private void logConnection(Channel channel, Throwable e) {
        if (e == null) {
            LOGGER.debug("Connected to {}", (Object)channel.remoteAddress());
        } else {
            LOGGER.debug("Failed to connect to {}", (Object)channel.remoteAddress(), (Object)e);
        }
    }
}

