/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.zeebe.util;

import io.atomix.raft.RaftServer;
import io.atomix.raft.partition.impl.RaftPartitionServer;
import io.atomix.raft.storage.log.IndexedRaftLogEntry;
import io.atomix.raft.storage.log.RaftLogReader;
import io.atomix.raft.zeebe.ZeebeLogAppender;
import io.atomix.raft.zeebe.util.ZeebeTestNode;
import java.time.Duration;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.junit.Assert;

public class ZeebeTestHelper {
    private static final long DEFAULT_TIMEOUT_MS = 10000L;
    private final Collection<ZeebeTestNode> nodes;

    public ZeebeTestHelper(Collection<ZeebeTestNode> nodes) {
        this.nodes = nodes;
    }

    public ZeebeLogAppender awaitLeaderAppender(int partitionId) {
        RaftPartitionServer server = this.awaitLeaderServer(partitionId);
        return (ZeebeLogAppender)this.await(() -> ((RaftPartitionServer)server).getAppender());
    }

    public RaftPartitionServer awaitLeaderServer(int partitionId) {
        return this.awaitLeader(partitionId).getPartitionServer(partitionId);
    }

    public ZeebeTestNode awaitLeader(int partitionId) {
        return (ZeebeTestNode)this.await(() -> this.getLeader(partitionId));
    }

    public ZeebeTestNode awaitLeader(int partitionId, Collection<ZeebeTestNode> nodes) {
        return (ZeebeTestNode)this.await(() -> this.getLeader(partitionId, nodes));
    }

    public Optional<ZeebeTestNode> getLeader(int partitionId) {
        return this.getLeader(partitionId, this.nodes);
    }

    public Optional<ZeebeTestNode> getLeader(int partitionId, Collection<ZeebeTestNode> nodes) {
        return nodes.stream().filter(n -> n.getPartition(partitionId).getRole() == RaftServer.Role.LEADER).findFirst();
    }

    public void awaitAllContain(int partitionId, IndexedRaftLogEntry indexed) {
        this.awaitAllContains(this.nodes, partitionId, indexed);
    }

    public void awaitAllContains(Collection<ZeebeTestNode> nodes, int partitionId, IndexedRaftLogEntry indexed) {
        this.await(() -> nodes.stream().allMatch(node -> this.containsIndexed((ZeebeTestNode)node, partitionId, indexed)));
    }

    public boolean containsIndexed(ZeebeTestNode node, int partitionId, IndexedRaftLogEntry indexed) {
        RaftPartitionServer partition = node.getPartitionServer(partitionId);
        return this.containsIndexed(partition, indexed);
    }

    public boolean containsIndexed(RaftPartitionServer partition, IndexedRaftLogEntry indexed) {
        try (RaftLogReader reader = partition.openReader();){
            IndexedRaftLogEntry entry;
            reader.seek(indexed.index());
            if (reader.hasNext() && (entry = (IndexedRaftLogEntry)reader.next()).index() == indexed.index()) {
                boolean bl = this.isEntryEqualTo(entry, indexed);
                return bl;
            }
        }
        return false;
    }

    public boolean isEntryEqualTo(IndexedRaftLogEntry indexed, IndexedRaftLogEntry other) {
        return indexed.equals((Object)other);
    }

    public void await(BooleanSupplier predicate) {
        long tries = Duration.ofMillis(10000L).toNanos() / 100L;
        boolean result = predicate.getAsBoolean();
        for (long i = 0L; i < tries && !result; ++i) {
            LockSupport.parkNanos(100L);
            result = predicate.getAsBoolean();
        }
        Assert.assertTrue((boolean)result);
    }

    public void awaitContains(ZeebeTestNode node, int partitionId, IndexedRaftLogEntry indexed) {
        this.await(() -> this.containsIndexed(node, partitionId, indexed));
    }

    public <T> T await(Supplier<Optional<T>> supplier) {
        this.await(supplier, Optional::isPresent);
        Optional<T> result = supplier.get();
        return result.get();
    }

    public <T> T await(Supplier<T> supplier, Predicate<T> condition) {
        this.await(() -> condition.test(supplier.get()));
        return supplier.get();
    }
}

