/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging.impl;

import io.atomix.cluster.messaging.ManagedUnicastService;
import io.atomix.cluster.messaging.MessagingConfig;
import io.atomix.cluster.messaging.impl.NettyUnicastService;
import io.atomix.utils.net.Address;
import io.camunda.zeebe.test.util.socket.SocketUtil;
import net.jodah.concurrentunit.ConcurrentTestCase;
import org.agrona.CloseHelper;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class NettyUnicastServiceTest
extends ConcurrentTestCase {
    ManagedUnicastService service1;
    ManagedUnicastService service2;
    Address address1;
    Address address2;

    @Test
    public void testUnicast() throws Exception {
        this.service1.addListener("test", (address, payload) -> {
            Assertions.assertThat((Object)address).isEqualTo((Object)this.address2);
            Assertions.assertThat((byte[])payload).containsExactly("Hello world!".getBytes());
            this.resume();
        });
        this.service2.unicast(this.address1, "test", "Hello world!".getBytes());
        this.await(5000L);
    }

    @Test
    public void shouldNotThrowExceptionWhenServiceStopped() {
        this.service2.stop();
        Assertions.assertThatCode(() -> this.service2.unicast(this.address1, "test", "Hello world!".getBytes())).doesNotThrowAnyException();
    }

    @Before
    public void setUp() throws Exception {
        this.address1 = Address.from((String)"127.0.0.1", (int)SocketUtil.getNextAddress().getPort());
        this.address2 = Address.from((String)"127.0.0.1", (int)SocketUtil.getNextAddress().getPort());
        String clusterId = "testClusterId";
        this.service1 = new NettyUnicastService("testClusterId", this.address1, new MessagingConfig());
        this.service1.start().join();
        this.service2 = new NettyUnicastService("testClusterId", this.address2, new MessagingConfig());
        this.service2.start().join();
    }

    @After
    public void tearDown() throws Exception {
        CloseHelper.quietCloseAll((AutoCloseable[])new AutoCloseable[]{() -> this.service1.stop().join(), () -> this.service2.stop().join()});
    }
}

