/* Generated SBE (Simple Binary Encoding) message codec. */
package io.atomix.raft.storage.serializer;

import org.agrona.MutableDirectBuffer;
import org.agrona.DirectBuffer;
import org.agrona.sbe.*;

@SuppressWarnings("all")
public final class MetaEncoder implements MessageEncoderFlyweight
{
    public static final int BLOCK_LENGTH = 16;
    public static final int TEMPLATE_ID = 6;
    public static final int SCHEMA_ID = 8;
    public static final int SCHEMA_VERSION = 3;
    public static final String SEMANTIC_VERSION = "0.1.0";
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final MetaEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int offset;
    private int limit;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public MutableDirectBuffer buffer()
    {
        return buffer;
    }

    public int offset()
    {
        return offset;
    }

    public MetaEncoder wrap(final MutableDirectBuffer buffer, final int offset)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.offset = offset;
        limit(offset + BLOCK_LENGTH);

        return this;
    }

    public MetaEncoder wrapAndApplyHeader(
        final MutableDirectBuffer buffer, final int offset, final MessageHeaderEncoder headerEncoder)
    {
        headerEncoder
            .wrap(buffer, offset)
            .blockLength(BLOCK_LENGTH)
            .templateId(TEMPLATE_ID)
            .schemaId(SCHEMA_ID)
            .version(SCHEMA_VERSION);

        return wrap(buffer, offset + MessageHeaderEncoder.ENCODED_LENGTH);
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int termId()
    {
        return 0;
    }

    public static int termSinceVersion()
    {
        return 0;
    }

    public static int termEncodingOffset()
    {
        return 0;
    }

    public static int termEncodingLength()
    {
        return 8;
    }

    public static String termMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long termNullValue()
    {
        return 0xffffffffffffffffL;
    }

    public static long termMinValue()
    {
        return 0x0L;
    }

    public static long termMaxValue()
    {
        return 0xfffffffffffffffeL;
    }

    public MetaEncoder term(final long value)
    {
        buffer.putLong(offset + 0, value, BYTE_ORDER);
        return this;
    }


    public static int lastFlushedIndexId()
    {
        return 1;
    }

    public static int lastFlushedIndexSinceVersion()
    {
        return 0;
    }

    public static int lastFlushedIndexEncodingOffset()
    {
        return 8;
    }

    public static int lastFlushedIndexEncodingLength()
    {
        return 8;
    }

    public static String lastFlushedIndexMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long lastFlushedIndexNullValue()
    {
        return 0xffffffffffffffffL;
    }

    public static long lastFlushedIndexMinValue()
    {
        return 0x0L;
    }

    public static long lastFlushedIndexMaxValue()
    {
        return 0xfffffffffffffffeL;
    }

    public MetaEncoder lastFlushedIndex(final long value)
    {
        buffer.putLong(offset + 8, value, BYTE_ORDER);
        return this;
    }


    public static int votedForId()
    {
        return 2;
    }

    public static String votedForCharacterEncoding()
    {
        return java.nio.charset.StandardCharsets.UTF_8.name();
    }

    public static String votedForMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int votedForHeaderLength()
    {
        return 4;
    }

    public MetaEncoder putVotedFor(final DirectBuffer src, final int srcOffset, final int length)
    {
        if (length > 2147483647)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, BYTE_ORDER);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public MetaEncoder putVotedFor(final byte[] src, final int srcOffset, final int length)
    {
        if (length > 2147483647)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, BYTE_ORDER);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public MetaEncoder votedFor(final String value)
    {
        final byte[] bytes = (null == value || value.isEmpty()) ? org.agrona.collections.ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(java.nio.charset.StandardCharsets.UTF_8);

        final int length = bytes.length;
        if (length > 2147483647)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, BYTE_ORDER);
        buffer.putBytes(limit + headerLength, bytes, 0, length);

        return this;
    }

    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        return appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final MetaDecoder decoder = new MetaDecoder();
        decoder.wrap(buffer, offset, BLOCK_LENGTH, SCHEMA_VERSION);

        return decoder.appendTo(builder);
    }
}
