/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.utils;

import io.atomix.cluster.MemberId;
import io.atomix.raft.utils.VoteQuorum;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;

public class SimpleVoteQuorum
implements VoteQuorum {
    private Consumer<Boolean> callback;
    private boolean complete;
    private final Set<MemberId> members;
    private int succeeded;
    private int failed;
    private final int quorum;

    public SimpleVoteQuorum(Consumer<Boolean> callback, Collection<MemberId> members) {
        this.callback = callback;
        this.members = new HashSet<MemberId>(members);
        this.quorum = members.size() / 2 + 1;
    }

    @Override
    public void succeed(MemberId member) {
        if (this.members.remove(member)) {
            ++this.succeeded;
            this.checkComplete();
        }
    }

    @Override
    public void fail(MemberId member) {
        if (this.members.remove(member)) {
            ++this.failed;
            this.checkComplete();
        }
    }

    @Override
    public void cancel() {
        this.callback = null;
        this.complete = true;
    }

    private void checkComplete() {
        if (!this.complete && this.callback != null) {
            if (this.succeeded >= this.quorum) {
                this.complete = true;
                this.callback.accept(true);
            } else if (this.failed >= this.quorum) {
                this.complete = true;
                this.callback.accept(false);
            }
        }
    }
}

