/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging;

import io.atomix.utils.config.Config;
import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

public class MessagingConfig
implements Config {
    private final int connectionPoolSize = 8;
    private List<String> interfaces = new ArrayList<String>();
    private Integer port;
    private Duration shutdownQuietPeriod = Duration.ofMillis(20L);
    private Duration shutdownTimeout = Duration.ofSeconds(1L);
    private boolean tlsEnabled = false;
    private File certificateChain;
    private File privateKey;
    private CompressionAlgorithm compressionAlgorithm = CompressionAlgorithm.NONE;
    private File keyStore;
    private String keyStorePassword;
    private Duration heartbeatTimeout = Duration.ofSeconds(15L);
    private Duration heartbeatInterval = Duration.ofSeconds(5L);

    public List<String> getInterfaces() {
        return this.interfaces;
    }

    public MessagingConfig setInterfaces(List<String> interfaces) {
        this.interfaces = interfaces;
        return this;
    }

    public Integer getPort() {
        return this.port;
    }

    public MessagingConfig setPort(Integer port) {
        this.port = port;
        return this;
    }

    public int getConnectionPoolSize() {
        return 8;
    }

    public Duration getShutdownQuietPeriod() {
        return this.shutdownQuietPeriod;
    }

    public MessagingConfig setShutdownQuietPeriod(Duration shutdownQuietPeriod) {
        this.shutdownQuietPeriod = shutdownQuietPeriod;
        return this;
    }

    public Duration getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public MessagingConfig setShutdownTimeout(Duration shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
        return this;
    }

    public boolean isTlsEnabled() {
        return this.tlsEnabled;
    }

    public MessagingConfig setTlsEnabled(boolean tlsEnabled) {
        this.tlsEnabled = tlsEnabled;
        return this;
    }

    public CompressionAlgorithm getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    public MessagingConfig setCompressionAlgorithm(CompressionAlgorithm algorithm) {
        this.compressionAlgorithm = algorithm;
        return this;
    }

    public File getCertificateChain() {
        return this.certificateChain;
    }

    public MessagingConfig setCertificateChain(File certificateChain) {
        if (certificateChain == null) {
            throw new IllegalArgumentException("Expected a certificate chain in order to enable inter-cluster communication security, but none given");
        }
        if (!certificateChain.canRead()) {
            throw new IllegalArgumentException(String.format("Expected the node's inter-cluster communication certificate to be at %s, but either the file is missing or it is not readable", certificateChain));
        }
        this.certificateChain = certificateChain;
        return this;
    }

    public File getPrivateKey() {
        return this.privateKey;
    }

    public MessagingConfig setPrivateKey(File privateKey) {
        if (privateKey == null) {
            throw new IllegalArgumentException("Expected a private key in order to enable inter-cluster communication security, but none given");
        }
        if (!privateKey.canRead()) {
            throw new IllegalArgumentException(String.format("Expected the node's inter-cluster communication private key to be at %s, but either the file is missing or it is not readable", privateKey));
        }
        this.privateKey = privateKey;
        return this;
    }

    public MessagingConfig configureTls(File keyStore, String keyStorePassword, File privateKey, File certificateChain) {
        if (keyStore != null) {
            this.keyStore = keyStore;
            this.keyStorePassword = keyStorePassword;
        } else {
            this.setPrivateKey(privateKey);
            this.setCertificateChain(certificateChain);
        }
        return this;
    }

    public File getKeyStore() {
        return this.keyStore;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public Duration getHeartbeatTimeout() {
        return this.heartbeatTimeout;
    }

    public MessagingConfig setHeartbeatTimeout(Duration heartbeatTimeout) {
        this.heartbeatTimeout = heartbeatTimeout;
        return this;
    }

    public Duration getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public MessagingConfig setHeartbeatInterval(Duration heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
        return this;
    }

    public static enum CompressionAlgorithm {
        GZIP,
        NONE,
        SNAPPY;

    }
}

