/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.impl;

import io.atomix.cluster.BootstrapService;
import io.atomix.cluster.Member;
import io.atomix.cluster.MemberId;
import io.atomix.cluster.Node;
import io.atomix.cluster.discovery.NodeDiscoveryEvent;
import io.atomix.cluster.discovery.NodeDiscoveryEventListener;
import io.atomix.cluster.discovery.NodeDiscoveryService;
import io.atomix.cluster.protocol.GroupMembershipEvent;
import io.atomix.cluster.protocol.GroupMembershipEventListener;
import io.atomix.cluster.protocol.GroupMembershipProtocol;
import io.atomix.cluster.protocol.GroupMembershipProtocolConfig;
import io.atomix.utils.event.AbstractListenerManager;
import io.atomix.utils.event.Event;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DiscoveryMembershipProtocol
extends AbstractListenerManager<GroupMembershipEvent, GroupMembershipEventListener>
implements GroupMembershipProtocol,
NodeDiscoveryEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiscoveryMembershipProtocol.class);
    private final ConcurrentMap<MemberId, Member> members = new ConcurrentHashMap<MemberId, Member>();
    private final AtomicBoolean started = new AtomicBoolean();
    private NodeDiscoveryService discoveryService;

    public DiscoveryMembershipProtocol() {
    }

    public DiscoveryMembershipProtocol(Config config) {
        this(config.members);
    }

    public DiscoveryMembershipProtocol(Map<MemberId, Member> members) {
        this.members.putAll(members);
    }

    @Override
    public Set<Member> getMembers() {
        return new HashSet<Member>(this.members.values());
    }

    @Override
    public Member getMember(MemberId memberId) {
        return (Member)this.members.get(memberId);
    }

    @Override
    public CompletableFuture<Void> join(BootstrapService bootstrap, NodeDiscoveryService discovery, Member localMember) {
        if (this.started.compareAndSet(false, true)) {
            discovery.getNodes().forEach(n -> {
                MemberId memberId = MemberId.from((String)((Object)n.id().id()));
                this.members.put(memberId, Member.member(memberId, n.address()));
            });
            this.members.put(localMember.id(), localMember);
            this.post((Event)new GroupMembershipEvent(GroupMembershipEvent.Type.MEMBER_ADDED, localMember));
            this.discoveryService = discovery;
            this.discoveryService.addListener(this);
            LOGGER.info("Started discovery membership protocol with members [{}]", this.members);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> leave(Member localMember) {
        if (this.started.compareAndSet(true, false)) {
            LOGGER.info("Stopped discovery membership protocol");
            this.discoveryService.removeListener(this);
            this.members.clear();
        }
        return CompletableFuture.completedFuture(null);
    }

    public void event(NodeDiscoveryEvent event) {
        Node node = event.node();
        MemberId memberId = MemberId.from((String)((Object)node.id().id()));
        Member member = Member.member(memberId, node.address());
        if (event.type() == NodeDiscoveryEvent.Type.JOIN) {
            if (this.members.put(memberId, member) == null) {
                this.post((Event)new GroupMembershipEvent(GroupMembershipEvent.Type.MEMBER_ADDED, member));
            }
        } else if (event.type() == NodeDiscoveryEvent.Type.LEAVE && this.members.remove(memberId) != null) {
            this.post((Event)new GroupMembershipEvent(GroupMembershipEvent.Type.MEMBER_REMOVED, member));
        }
    }

    public GroupMembershipProtocolConfig config() {
        return new Config(new HashMap<MemberId, Member>(this.members));
    }

    public static final class Config
    extends GroupMembershipProtocolConfig {
        private final Map<MemberId, Member> members;

        public Config(Map<MemberId, Member> members) {
            this.members = members;
        }

        public Map<MemberId, Member> members() {
            return this.members;
        }

        public GroupMembershipProtocol.Type<Config> getType() {
            return new Type();
        }
    }

    private static final class Type
    implements GroupMembershipProtocol.Type<Config> {
        private Type() {
        }

        public String name() {
            return "memory";
        }

        @Override
        public GroupMembershipProtocol newProtocol(Config config) {
            return new DiscoveryMembershipProtocol(config);
        }
    }
}

