/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.zeebe.util;

import io.atomix.raft.storage.log.IndexedRaftLogEntry;
import io.atomix.raft.zeebe.ZeebeLogAppender;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class TestAppender
implements ZeebeLogAppender.AppendListener {
    private final BlockingQueue<IndexedRaftLogEntry> written = new LinkedBlockingQueue<IndexedRaftLogEntry>();
    private final BlockingQueue<Long> committed = new LinkedBlockingQueue<Long>();
    private final BlockingQueue<Throwable> errors = new LinkedBlockingQueue<Throwable>();

    public void onWrite(IndexedRaftLogEntry indexed) {
        this.written.offer(indexed);
    }

    public void onWriteError(Throwable error) {
        this.errors.offer(error);
    }

    public void onCommit(long index, long highestPosition) {
        this.committed.offer(index);
    }

    public void onCommitError(long index, Throwable error) {
        this.errors.offer(error);
    }

    public IndexedRaftLogEntry append(ZeebeLogAppender appender, long lowest, long highest, ByteBuffer data) {
        appender.appendEntry(lowest, highest, data, (ZeebeLogAppender.AppendListener)this);
        return this.pollWritten();
    }

    public IndexedRaftLogEntry pollWritten() {
        return this.takeUnchecked(this.written);
    }

    public Long pollCommitted() {
        return this.takeUnchecked(this.committed);
    }

    public Throwable pollError() {
        return this.takeUnchecked(this.errors);
    }

    public List<IndexedRaftLogEntry> getWritten() {
        return new ArrayList<IndexedRaftLogEntry>(this.written);
    }

    public List<Long> getCommitted() {
        return new ArrayList<Long>(this.committed);
    }

    public List<Throwable> getErrors() {
        return new ArrayList<Throwable>(this.errors);
    }

    private <T> T takeUnchecked(BlockingQueue<T> queue) {
        try {
            return queue.take();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }
}

