/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.utils;

import io.atomix.cluster.MemberId;
import io.atomix.raft.utils.JointConsensusVoteQuorum;
import io.atomix.raft.utils.SimpleVoteQuorum;
import java.util.Set;
import java.util.function.Consumer;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

final class VoteQuorumTest {
    VoteQuorumTest() {
    }

    @Nested
    final class JointConsensus {
        JointConsensus(VoteQuorumTest this$0) {
        }

        @Test
        void shouldSucceedWithOverlappingMembers() {
            Consumer callback = (Consumer)Mockito.mock((Object[])new Consumer[0]);
            JointConsensusVoteQuorum quorum = new JointConsensusVoteQuorum(callback, Set.of(MemberId.from((String)"1"), MemberId.from((String)"2"), MemberId.from((String)"4")), Set.of(MemberId.from((String)"1"), MemberId.from((String)"2"), MemberId.from((String)"3")));
            quorum.succeed(new MemberId("1"));
            quorum.succeed(new MemberId("2"));
            ((Consumer)Mockito.verify((Object)callback, (VerificationMode)Mockito.only())).accept(true);
        }

        @Test
        void shouldSucceedWithDisjointMembers() {
            Consumer callback = (Consumer)Mockito.mock((Object[])new Consumer[0]);
            JointConsensusVoteQuorum quorum = new JointConsensusVoteQuorum(callback, Set.of(MemberId.from((String)"1"), MemberId.from((String)"2"), MemberId.from((String)"3")), Set.of(MemberId.from((String)"4"), MemberId.from((String)"5"), MemberId.from((String)"6")));
            quorum.succeed(new MemberId("1"));
            quorum.succeed(new MemberId("2"));
            quorum.succeed(new MemberId("4"));
            quorum.succeed(new MemberId("5"));
            ((Consumer)Mockito.verify((Object)callback, (VerificationMode)Mockito.only())).accept(true);
        }

        @Test
        void shouldWaitWithQuorumOfOldMembers() {
            Consumer callback = (Consumer)Mockito.mock((Object[])new Consumer[0]);
            JointConsensusVoteQuorum quorum = new JointConsensusVoteQuorum(callback, Set.of(MemberId.from((String)"1"), MemberId.from((String)"2"), MemberId.from((String)"4")), Set.of(MemberId.from((String)"1"), MemberId.from((String)"2"), MemberId.from((String)"3")));
            quorum.succeed(new MemberId("1"));
            quorum.succeed(new MemberId("4"));
            Mockito.verifyNoInteractions((Object[])new Object[]{callback});
        }

        @Test
        void shouldWaitWithQuorumOfNewMembers() {
            Consumer callback = (Consumer)Mockito.mock((Object[])new Consumer[0]);
            JointConsensusVoteQuorum quorum = new JointConsensusVoteQuorum(callback, Set.of(MemberId.from((String)"1"), MemberId.from((String)"2"), MemberId.from((String)"4")), Set.of(MemberId.from((String)"1"), MemberId.from((String)"2"), MemberId.from((String)"3")));
            quorum.succeed(new MemberId("1"));
            quorum.succeed(new MemberId("3"));
            Mockito.verifyNoInteractions((Object[])new Object[]{callback});
        }

        @Test
        void shouldFailOnPartialFailure() {
            Consumer callback = (Consumer)Mockito.mock((Object[])new Consumer[0]);
            JointConsensusVoteQuorum quorum = new JointConsensusVoteQuorum(callback, Set.of(MemberId.from((String)"1"), MemberId.from((String)"2"), MemberId.from((String)"4")), Set.of(MemberId.from((String)"1"), MemberId.from((String)"2"), MemberId.from((String)"3")));
            quorum.fail(new MemberId("1"));
            quorum.fail(new MemberId("4"));
            ((Consumer)Mockito.verify((Object)callback, (VerificationMode)Mockito.only())).accept(false);
        }

        @Test
        void shouldNotRecoverFromFailure() {
            Consumer callback = (Consumer)Mockito.mock((Object[])new Consumer[0]);
            JointConsensusVoteQuorum quorum = new JointConsensusVoteQuorum(callback, Set.of(MemberId.from((String)"1"), MemberId.from((String)"2"), MemberId.from((String)"4")), Set.of(MemberId.from((String)"1"), MemberId.from((String)"2"), MemberId.from((String)"3")));
            quorum.fail(new MemberId("1"));
            quorum.fail(new MemberId("4"));
            quorum.succeed(new MemberId("1"));
            quorum.succeed(new MemberId("2"));
            quorum.succeed(new MemberId("3"));
            ((Consumer)Mockito.verify((Object)callback, (VerificationMode)Mockito.only())).accept(false);
        }
    }

    @Nested
    final class SimpleVoteQuorumTest {
        SimpleVoteQuorumTest(VoteQuorumTest this$0) {
        }

        @Test
        void shouldWaitWith1OutOf3() {
            Consumer callback = (Consumer)Mockito.mock((Object[])new Consumer[0]);
            SimpleVoteQuorum quorum = new SimpleVoteQuorum(callback, Set.of(MemberId.from((String)"1"), MemberId.from((String)"2"), MemberId.from((String)"3")));
            quorum.succeed(new MemberId("1"));
            Mockito.verifyNoInteractions((Object[])new Object[]{callback});
        }

        @Test
        void shouldSucceedWith2OutOf3() {
            Consumer callback = (Consumer)Mockito.mock((Object[])new Consumer[0]);
            SimpleVoteQuorum quorum = new SimpleVoteQuorum(callback, Set.of(MemberId.from((String)"1"), MemberId.from((String)"2"), MemberId.from((String)"3")));
            quorum.succeed(new MemberId("1"));
            quorum.succeed(new MemberId("2"));
            ((Consumer)Mockito.verify((Object)callback, (VerificationMode)Mockito.only())).accept(true);
        }

        @Test
        void shouldIgnoreDuplicates() {
            Consumer callback = (Consumer)Mockito.mock((Object[])new Consumer[0]);
            SimpleVoteQuorum quorum = new SimpleVoteQuorum(callback, Set.of(MemberId.from((String)"1"), MemberId.from((String)"2"), MemberId.from((String)"3")));
            quorum.succeed(new MemberId("1"));
            quorum.succeed(new MemberId("1"));
            Mockito.verifyNoInteractions((Object[])new Object[]{callback});
        }

        @Test
        void shouldIgnoreUnknown() {
            Consumer callback = (Consumer)Mockito.mock((Object[])new Consumer[0]);
            SimpleVoteQuorum quorum = new SimpleVoteQuorum(callback, Set.of(MemberId.from((String)"1"), MemberId.from((String)"2"), MemberId.from((String)"3")));
            quorum.succeed(new MemberId("5"));
            quorum.succeed(new MemberId("6"));
            Mockito.verifyNoInteractions((Object[])new Object[]{callback});
        }

        @Test
        void shouldOnlySucceedOnce() {
            Consumer callback = (Consumer)Mockito.mock((Object[])new Consumer[0]);
            SimpleVoteQuorum quorum = new SimpleVoteQuorum(callback, Set.of(MemberId.from((String)"1"), MemberId.from((String)"2"), MemberId.from((String)"3")));
            quorum.succeed(new MemberId("1"));
            quorum.succeed(new MemberId("2"));
            quorum.succeed(new MemberId("3"));
            ((Consumer)Mockito.verify((Object)callback, (VerificationMode)Mockito.only())).accept(true);
        }

        @Test
        void shouldFail() {
            Consumer callback = (Consumer)Mockito.mock((Object[])new Consumer[0]);
            SimpleVoteQuorum quorum = new SimpleVoteQuorum(callback, Set.of(MemberId.from((String)"1"), MemberId.from((String)"2"), MemberId.from((String)"3")));
            quorum.fail(new MemberId("1"));
            quorum.fail(new MemberId("2"));
            ((Consumer)Mockito.verify((Object)callback, (VerificationMode)Mockito.only())).accept(false);
        }

        @Test
        void shouldNotRecoverFromFail() {
            Consumer callback = (Consumer)Mockito.mock((Object[])new Consumer[0]);
            SimpleVoteQuorum quorum = new SimpleVoteQuorum(callback, Set.of(MemberId.from((String)"1"), MemberId.from((String)"2"), MemberId.from((String)"3")));
            quorum.fail(new MemberId("1"));
            quorum.fail(new MemberId("2"));
            quorum.succeed(new MemberId("1"));
            quorum.succeed(new MemberId("2"));
            ((Consumer)Mockito.verify((Object)callback, (VerificationMode)Mockito.only())).accept(false);
        }
    }
}

