/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.storage.serializer;

import io.atomix.raft.storage.serializer.BlobDecoder;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.CompositeEncoderFlyweight;

public final class BlobEncoder
implements CompositeEncoderFlyweight {
    public static final int SCHEMA_ID = 8;
    public static final int SCHEMA_VERSION = 4;
    public static final String SEMANTIC_VERSION = "0.1.0";
    public static final int ENCODED_LENGTH = -1;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private int offset;
    private MutableDirectBuffer buffer;

    public BlobEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        return this;
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public int encodedLength() {
        return -1;
    }

    public int sbeSchemaId() {
        return 8;
    }

    public int sbeSchemaVersion() {
        return 4;
    }

    public static int lengthEncodingOffset() {
        return 0;
    }

    public static int lengthEncodingLength() {
        return 4;
    }

    public static long lengthNullValue() {
        return 0xFFFFFFFFL;
    }

    public static long lengthMinValue() {
        return 0L;
    }

    public static long lengthMaxValue() {
        return Integer.MAX_VALUE;
    }

    public BlobEncoder length(long value) {
        this.buffer.putInt(this.offset + 0, (int)value, BYTE_ORDER);
        return this;
    }

    public static int varDataEncodingOffset() {
        return 4;
    }

    public static int varDataEncodingLength() {
        return -1;
    }

    public static short varDataNullValue() {
        return 255;
    }

    public static short varDataMinValue() {
        return 0;
    }

    public static short varDataMaxValue() {
        return 254;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        BlobDecoder decoder = new BlobDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.offset);
        return decoder.appendTo(builder);
    }
}

