/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.protocol;

import com.google.common.collect.Sets;
import io.atomix.cluster.MemberId;
import io.atomix.raft.protocol.AppendRequest;
import io.atomix.raft.protocol.AppendResponse;
import io.atomix.raft.protocol.ConfigureRequest;
import io.atomix.raft.protocol.ConfigureResponse;
import io.atomix.raft.protocol.ForceConfigureRequest;
import io.atomix.raft.protocol.ForceConfigureResponse;
import io.atomix.raft.protocol.InstallRequest;
import io.atomix.raft.protocol.InstallResponse;
import io.atomix.raft.protocol.JoinRequest;
import io.atomix.raft.protocol.JoinResponse;
import io.atomix.raft.protocol.LeaveRequest;
import io.atomix.raft.protocol.LeaveResponse;
import io.atomix.raft.protocol.PollRequest;
import io.atomix.raft.protocol.PollResponse;
import io.atomix.raft.protocol.RaftResponse;
import io.atomix.raft.protocol.RaftServerProtocol;
import io.atomix.raft.protocol.ReconfigureRequest;
import io.atomix.raft.protocol.ReconfigureResponse;
import io.atomix.raft.protocol.TransferRequest;
import io.atomix.raft.protocol.TransferResponse;
import io.atomix.raft.protocol.VersionedAppendRequest;
import io.atomix.raft.protocol.VoteRequest;
import io.atomix.raft.protocol.VoteResponse;
import java.net.ConnectException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public class TestRaftServerProtocol
implements RaftServerProtocol {
    private static final long REQUEST_TIMEOUT_MS = 1000L;
    private static final long CONFIGURATION_REQUEST_TIMEOUT_MS = 4000L;
    private Function<ConfigureRequest, CompletableFuture<ConfigureResponse>> configureHandler;
    private Function<ReconfigureRequest, CompletableFuture<ReconfigureResponse>> reconfigureHandler;
    private Function<ForceConfigureRequest, CompletableFuture<ForceConfigureResponse>> forceConfigureHandler;
    private Function<JoinRequest, CompletableFuture<JoinResponse>> joinHandler;
    private Function<LeaveRequest, CompletableFuture<LeaveResponse>> leaveHandler;
    private Function<InstallRequest, CompletableFuture<InstallResponse>> installHandler;
    private Function<TransferRequest, CompletableFuture<TransferResponse>> transferHandler;
    private Function<PollRequest, CompletableFuture<PollResponse>> pollHandler;
    private Function<VoteRequest, CompletableFuture<VoteResponse>> voteHandler;
    private Function<VersionedAppendRequest, CompletableFuture<AppendResponse>> appendHandler;
    private final Set<MemberId> partitions = Sets.newCopyOnWriteArraySet();
    private final Map<Class<?>, BiFunction<?, TestRaftServerProtocol, CompletableFuture<TestRaftServerProtocol>>> interceptors = new ConcurrentHashMap();
    private final Map<MemberId, TestRaftServerProtocol> servers;
    private final Map<Class<?>, ResponseInterceptor<?>> responseInterceptors = new ConcurrentHashMap();

    public TestRaftServerProtocol(MemberId memberId, Map<MemberId, TestRaftServerProtocol> servers) {
        this.servers = servers;
        servers.put(memberId, this);
    }

    public void disconnect(MemberId target) {
        this.partitions.add(target);
    }

    public void reconnect(MemberId target) {
        this.partitions.remove(target);
    }

    TestRaftServerProtocol server(MemberId memberId) {
        if (this.partitions.contains(memberId)) {
            return null;
        }
        return this.servers.get(memberId);
    }

    public CompletableFuture<ConfigureResponse> configure(MemberId memberId, ConfigureRequest request) {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.getServer(memberId).thenCompose(listener -> this.intercept((TestRaftServerProtocol)listener, (Object)request, (Class)ConfigureRequest.class))).thenCompose(listener -> listener.configure(request))).thenCompose(response -> this.transformResponse(response, ConfigureResponse.class))).orTimeout(1000L, TimeUnit.MILLISECONDS);
    }

    public CompletableFuture<ReconfigureResponse> reconfigure(MemberId memberId, ReconfigureRequest request) {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.getServer(memberId).thenCompose(listener -> this.intercept((TestRaftServerProtocol)listener, (Object)request, (Class)ReconfigureRequest.class))).thenCompose(listener -> listener.reconfigure(request))).thenCompose(response -> this.transformResponse(response, ReconfigureResponse.class))).orTimeout(4000L, TimeUnit.MILLISECONDS);
    }

    public CompletableFuture<ForceConfigureResponse> forceConfigure(MemberId memberId, ForceConfigureRequest request) {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.getServer(memberId).thenCompose(listener -> this.intercept((TestRaftServerProtocol)listener, (Object)request, (Class)ForceConfigureRequest.class))).thenCompose(listener -> listener.forceConfigure(request))).thenCompose(response -> this.transformResponse(response, ForceConfigureResponse.class))).orTimeout(1000L, TimeUnit.MILLISECONDS);
    }

    public CompletableFuture<JoinResponse> join(MemberId memberId, JoinRequest request) {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.getServer(memberId).thenCompose(listener -> this.intercept((TestRaftServerProtocol)listener, (Object)request, (Class)JoinRequest.class))).thenCompose(listener -> listener.join(request))).thenCompose(response -> this.transformResponse(response, JoinResponse.class))).orTimeout(4000L, TimeUnit.MILLISECONDS);
    }

    public CompletableFuture<LeaveResponse> leave(MemberId memberId, LeaveRequest request) {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.getServer(memberId).thenCompose(listener -> this.intercept((TestRaftServerProtocol)listener, (Object)request, (Class)LeaveRequest.class))).thenCompose(listener -> listener.leave(request))).thenCompose(response -> this.transformResponse(response, LeaveResponse.class))).orTimeout(4000L, TimeUnit.MILLISECONDS);
    }

    public CompletableFuture<InstallResponse> install(MemberId memberId, InstallRequest request) {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.getServer(memberId).thenCompose(listener -> this.intercept((TestRaftServerProtocol)listener, (Object)request, (Class)InstallRequest.class))).thenCompose(listener -> listener.install(request))).thenCompose(response -> this.transformResponse(response, InstallResponse.class))).orTimeout(1000L, TimeUnit.MILLISECONDS);
    }

    public CompletableFuture<TransferResponse> transfer(MemberId memberId, TransferRequest request) {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.getServer(memberId).thenCompose(listener -> this.intercept((TestRaftServerProtocol)listener, (Object)request, (Class)TransferRequest.class))).thenCompose(listener -> listener.transfer(request))).thenCompose(response -> this.transformResponse(response, TransferResponse.class))).orTimeout(1000L, TimeUnit.MILLISECONDS);
    }

    public CompletableFuture<PollResponse> poll(MemberId memberId, PollRequest request) {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.getServer(memberId).thenCompose(listener -> this.intercept((TestRaftServerProtocol)listener, (Object)request, (Class)PollRequest.class))).thenCompose(listener -> listener.poll(request))).thenCompose(response -> this.transformResponse(response, PollResponse.class))).orTimeout(1000L, TimeUnit.MILLISECONDS);
    }

    public CompletableFuture<VoteResponse> vote(MemberId memberId, VoteRequest request) {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.getServer(memberId).thenCompose(listener -> this.intercept((TestRaftServerProtocol)listener, (Object)request, (Class)VoteRequest.class))).thenCompose(listener -> listener.vote(request))).thenCompose(response -> this.transformResponse(response, VoteResponse.class))).orTimeout(1000L, TimeUnit.MILLISECONDS);
    }

    public CompletableFuture<AppendResponse> append(MemberId memberId, AppendRequest request) {
        throw new IllegalArgumentException("Using old version not supported in tests");
    }

    public CompletableFuture<AppendResponse> append(MemberId memberId, VersionedAppendRequest request) {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.getServer(memberId).thenCompose(listener -> this.intercept((TestRaftServerProtocol)listener, (Object)request, (Class)VersionedAppendRequest.class))).thenCompose(listener -> listener.append(request))).thenCompose(response -> this.transformResponse(response, AppendResponse.class))).orTimeout(1000L, TimeUnit.MILLISECONDS);
    }

    public void registerTransferHandler(Function<TransferRequest, CompletableFuture<TransferResponse>> handler) {
        this.transferHandler = handler;
    }

    public void unregisterTransferHandler() {
        this.transferHandler = null;
    }

    public void registerConfigureHandler(Function<ConfigureRequest, CompletableFuture<ConfigureResponse>> handler) {
        this.configureHandler = handler;
    }

    public void unregisterConfigureHandler() {
        this.configureHandler = null;
    }

    public void registerReconfigureHandler(Function<ReconfigureRequest, CompletableFuture<ReconfigureResponse>> handler) {
        this.reconfigureHandler = handler;
    }

    public void unregisterReconfigureHandler() {
        this.reconfigureHandler = null;
    }

    public void registerForceConfigureHandler(Function<ForceConfigureRequest, CompletableFuture<ForceConfigureResponse>> handler) {
        this.forceConfigureHandler = handler;
    }

    public void unregisterForceConfigureHandler() {
        this.forceConfigureHandler = null;
    }

    public void registerJoinHandler(Function<JoinRequest, CompletableFuture<JoinResponse>> handler) {
        this.joinHandler = handler;
    }

    public void unregisterJoinHandler() {
        this.joinHandler = null;
    }

    public void registerLeaveHandler(Function<LeaveRequest, CompletableFuture<LeaveResponse>> handler) {
        this.leaveHandler = handler;
    }

    public void unregisterLeaveHandler() {
        this.leaveHandler = null;
    }

    public void registerInstallHandler(Function<InstallRequest, CompletableFuture<InstallResponse>> handler) {
        this.installHandler = handler;
    }

    public void unregisterInstallHandler() {
        this.installHandler = null;
    }

    public void registerPollHandler(Function<PollRequest, CompletableFuture<PollResponse>> handler) {
        this.pollHandler = handler;
    }

    public void unregisterPollHandler() {
        this.pollHandler = null;
    }

    public void registerVoteHandler(Function<VoteRequest, CompletableFuture<VoteResponse>> handler) {
        this.voteHandler = handler;
    }

    public void unregisterVoteHandler() {
        this.voteHandler = null;
    }

    public void registerAppendV1Handler(Function<AppendRequest, CompletableFuture<AppendResponse>> handler) {
    }

    public void registerAppendV2Handler(Function<VersionedAppendRequest, CompletableFuture<AppendResponse>> handler) {
        this.appendHandler = handler;
    }

    public void unregisterAppendHandler() {
        this.appendHandler = null;
    }

    private CompletableFuture<TestRaftServerProtocol> getServer(MemberId memberId) {
        TestRaftServerProtocol server = this.server(memberId);
        if (server != null) {
            return CompletableFuture.completedFuture(server);
        }
        return CompletableFuture.failedFuture(new ConnectException());
    }

    CompletableFuture<AppendResponse> append(VersionedAppendRequest request) {
        if (this.appendHandler != null) {
            return this.appendHandler.apply(request);
        }
        return CompletableFuture.failedFuture(new ConnectException());
    }

    CompletableFuture<VoteResponse> vote(VoteRequest request) {
        if (this.voteHandler != null) {
            return this.voteHandler.apply(request);
        }
        return CompletableFuture.failedFuture(new ConnectException());
    }

    CompletableFuture<PollResponse> poll(PollRequest request) {
        if (this.pollHandler != null) {
            return this.intercept(null, request, PollRequest.class).thenCompose(ignore -> this.pollHandler.apply(request));
        }
        return CompletableFuture.failedFuture(new ConnectException());
    }

    CompletableFuture<TransferResponse> transfer(TransferRequest request) {
        if (this.transferHandler != null) {
            return this.transferHandler.apply(request);
        }
        return CompletableFuture.failedFuture(new ConnectException());
    }

    CompletableFuture<InstallResponse> install(InstallRequest request) {
        if (this.installHandler != null) {
            return this.intercept(null, request, InstallRequest.class).thenCompose(ignore -> this.installHandler.apply(request));
        }
        return CompletableFuture.failedFuture(new ConnectException());
    }

    CompletableFuture<ReconfigureResponse> reconfigure(ReconfigureRequest request) {
        if (this.reconfigureHandler != null) {
            return this.reconfigureHandler.apply(request);
        }
        return CompletableFuture.failedFuture(new ConnectException());
    }

    CompletableFuture<ForceConfigureResponse> forceConfigure(ForceConfigureRequest request) {
        if (this.forceConfigureHandler != null) {
            return this.forceConfigureHandler.apply(request);
        }
        return CompletableFuture.failedFuture(new ConnectException());
    }

    CompletableFuture<JoinResponse> join(JoinRequest request) {
        if (this.joinHandler != null) {
            return this.joinHandler.apply(request);
        }
        return CompletableFuture.failedFuture(new ConnectException());
    }

    CompletableFuture<LeaveResponse> leave(LeaveRequest request) {
        if (this.leaveHandler != null) {
            return this.leaveHandler.apply(request);
        }
        return CompletableFuture.failedFuture(new ConnectException());
    }

    CompletableFuture<ConfigureResponse> configure(ConfigureRequest request) {
        if (this.configureHandler != null) {
            return this.configureHandler.apply(request);
        }
        return CompletableFuture.failedFuture(new ConnectException());
    }

    public <T> void interceptRequest(Class<T> requestType, Consumer<T> interceptor) {
        this.interceptors.put(requestType, (request, listener) -> {
            interceptor.accept(request);
            return CompletableFuture.completedFuture(listener);
        });
    }

    public <T> void interceptRequest(Class<T> requestType, Function<T, CompletableFuture<Void>> interceptor) {
        this.interceptors.put(requestType, (request, listener) -> ((CompletableFuture)interceptor.apply(request)).thenCompose(ignore -> CompletableFuture.completedFuture(listener)));
    }

    public <T extends RaftResponse> void interceptResponse(Class<T> responseType, ResponseInterceptor<T> interceptor) {
        this.responseInterceptors.put(responseType, interceptor);
    }

    private <T> CompletableFuture<T> transformResponse(T response, Class<T> responseType) {
        ResponseInterceptor<?> interceptor = this.responseInterceptors.get(responseType);
        if (interceptor != null) {
            return (CompletableFuture)interceptor.apply(response);
        }
        return CompletableFuture.completedFuture(response);
    }

    private <T> CompletableFuture<TestRaftServerProtocol> intercept(TestRaftServerProtocol listener, T request, Class<T> requestType) {
        BiFunction<?, TestRaftServerProtocol, CompletableFuture<TestRaftServerProtocol>> interceptor = this.interceptors.get(requestType);
        if (interceptor != null) {
            return interceptor.apply(request, listener);
        }
        return CompletableFuture.completedFuture(listener);
    }

    @FunctionalInterface
    public static interface ResponseInterceptor<T>
    extends Function<T, CompletableFuture<T>> {
    }
}

