/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.partition;

import io.atomix.cluster.MemberId;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.partition.PartitionMetadata;
import io.atomix.raft.partition.RaftPartition;
import io.atomix.raft.partition.RaftPartitionConfig;
import io.atomix.raft.partition.impl.RaftPartitionServer;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.Mockito;

final class StepDownIfNotPrimaryTest {
    StepDownIfNotPrimaryTest() {
    }

    @Test
    void shouldStepDownIfNotPrimary(@TempDir Path tempDir) throws IllegalAccessException {
        MemberId primaryMemberId = new MemberId("2");
        PartitionId partitionId = new PartitionId("group", 1);
        PartitionMetadata metadata = new PartitionMetadata(partitionId, Set.of(), Map.of(), 1, primaryMemberId);
        RaftPartitionConfig raftPartitionConfig = new RaftPartitionConfig();
        RaftPartition partition = new RaftPartition(metadata, raftPartitionConfig, tempDir.toFile());
        RaftPartitionServer mockRaftPartitionServer = (RaftPartitionServer)Mockito.mock(RaftPartitionServer.class);
        Mockito.when((Object)mockRaftPartitionServer.getMemberId()).thenReturn((Object)new MemberId("1"));
        FieldUtils.writeField((Object)partition, (String)"server", (Object)mockRaftPartitionServer, (boolean)true);
        raftPartitionConfig.setPriorityElectionEnabled(true);
        Assertions.assertThat((boolean)partition.shouldStepDown()).isTrue();
    }

    @Test
    void shouldNotStepDownIfPrimary(@TempDir Path tempDir) throws IllegalAccessException {
        PartitionId partitionId = new PartitionId("group", 1);
        MemberId primaryMemberId = new MemberId("1");
        RaftPartitionConfig raftPartitionConfig = new RaftPartitionConfig();
        PartitionMetadata metadata = new PartitionMetadata(partitionId, Set.of(), Map.of(), 1, primaryMemberId);
        RaftPartition partition = new RaftPartition(metadata, raftPartitionConfig, tempDir.toFile());
        RaftPartitionServer mockRaftPartitionServer = (RaftPartitionServer)Mockito.mock(RaftPartitionServer.class);
        Mockito.when((Object)mockRaftPartitionServer.getMemberId()).thenReturn((Object)new MemberId("1"));
        FieldUtils.writeField((Object)partition, (String)"server", (Object)mockRaftPartitionServer, (boolean)true);
        raftPartitionConfig.setPriorityElectionEnabled(true);
        Assertions.assertThat((boolean)partition.shouldStepDown()).isFalse();
    }

    @Test
    void shouldNotStepDownIfPriorityElectionDisabled(@TempDir Path tempDir) throws IllegalAccessException {
        PartitionId partitionId = new PartitionId("group", 1);
        RaftPartitionConfig raftPartitionConfig = new RaftPartitionConfig();
        MemberId primaryMemberId = new MemberId("2");
        PartitionMetadata metadata = new PartitionMetadata(partitionId, Set.of(), Map.of(), 1, primaryMemberId);
        RaftPartition partition = new RaftPartition(metadata, raftPartitionConfig, tempDir.toFile());
        RaftPartitionServer mockRaftPartitionServer = (RaftPartitionServer)Mockito.mock(RaftPartitionServer.class);
        Mockito.when((Object)mockRaftPartitionServer.getMemberId()).thenReturn((Object)new MemberId("1"));
        FieldUtils.writeField((Object)partition, (String)"server", (Object)mockRaftPartitionServer, (boolean)true);
        raftPartitionConfig.setPriorityElectionEnabled(false);
        Assertions.assertThat((boolean)partition.shouldStepDown()).isFalse();
    }

    @Test
    void shouldNotStepDownIfPartitionHasNoPrimary(@TempDir Path tempDir) throws IllegalAccessException {
        PartitionId partitionId = new PartitionId("group", 1);
        MemberId primaryMemberId = null;
        RaftPartitionConfig raftPartitionConfig = new RaftPartitionConfig();
        PartitionMetadata metadata = new PartitionMetadata(partitionId, Set.of(), Map.of(), 1, primaryMemberId);
        RaftPartition partition = new RaftPartition(metadata, raftPartitionConfig, tempDir.toFile());
        RaftPartitionServer mockRaftPartitionServer = (RaftPartitionServer)Mockito.mock(RaftPartitionServer.class);
        Mockito.when((Object)mockRaftPartitionServer.getMemberId()).thenReturn((Object)new MemberId("1"));
        FieldUtils.writeField((Object)partition, (String)"server", (Object)mockRaftPartitionServer, (boolean)true);
        raftPartitionConfig.setPriorityElectionEnabled(true);
        Assertions.assertThat((boolean)partition.shouldStepDown()).isFalse();
    }
}

