/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft;

import io.atomix.raft.RaftError;
import io.atomix.raft.RaftRule;
import io.atomix.raft.RaftServer;
import io.atomix.raft.protocol.InstallRequest;
import io.atomix.raft.protocol.InstallResponse;
import io.atomix.raft.protocol.RaftResponse;
import io.atomix.raft.protocol.TestRaftServerProtocol;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class RaftSnapshotReplicationFailureHandlingTest {
    @Rule
    public RaftRule raftRule = RaftRule.withBootstrappedNodes(3);
    private RaftServer follower;
    private AtomicInteger totalInstallRequest;
    private TestRaftServerProtocol leaderProtocol;
    private RaftServer leader;

    @Before
    public void setup() {
        this.leader = this.raftRule.getLeader().orElseThrow();
        this.leaderProtocol = (TestRaftServerProtocol)this.leader.getContext().getProtocol();
        this.totalInstallRequest = new AtomicInteger(0);
        this.leaderProtocol.interceptRequest(InstallRequest.class, request -> this.totalInstallRequest.incrementAndGet());
    }

    @Test
    public void shouldNotRestartFromFirstChunkWhenInstallRequestTimesOut() throws Throwable {
        int numberOfChunks = 10;
        this.disconnectFollowerAndTakeSnapshot(10);
        this.leaderProtocol.interceptResponse(InstallResponse.class, new TimingOutResponseInterceptor(9));
        this.reconnectFollowerAndAwaitSnapshot();
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.totalInstallRequest.get()).describedAs("Should only resend one snapshot chunk", new Object[0])).isLessThan(13);
    }

    @Test
    public void shouldRestartSnapshotReplicationIfFollowerRejectedRequest() throws Throwable {
        int numberOfChunks = 10;
        this.disconnectFollowerAndTakeSnapshot(10);
        this.leaderProtocol.interceptResponse(InstallResponse.class, new RejectingInterceptor(9));
        this.reconnectFollowerAndAwaitSnapshot();
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.totalInstallRequest.get()).describedAs("Should resent chunks from 0 to 8", new Object[0])).isLessThan(21);
    }

    @Test
    public void shouldResentSnapshotIfFirstChunkTimedOut() throws Throwable {
        boolean numberOfChunks = true;
        this.disconnectFollowerAndTakeSnapshot(1);
        TimingOutRequestInterceptor requestInterceptor = new TimingOutRequestInterceptor(1);
        this.leaderProtocol.interceptRequest(InstallRequest.class, requestInterceptor);
        this.reconnectFollowerAndAwaitSnapshot();
        ((AbstractIntegerAssert)Assertions.assertThat((int)requestInterceptor.getCount()).describedAs("Should resent snapshot chunk", new Object[0])).isEqualTo(2);
    }

    private void reconnectFollowerAndAwaitSnapshot() throws InterruptedException {
        CountDownLatch snapshotReceived = new CountDownLatch(1);
        this.raftRule.getPersistedSnapshotStore(this.follower.name()).addSnapshotListener(s -> snapshotReceived.countDown());
        this.raftRule.reconnect(this.follower);
        Assertions.assertThat((boolean)snapshotReceived.await(30L, TimeUnit.SECONDS)).isTrue();
    }

    private void disconnectFollowerAndTakeSnapshot(int numberOfChunks) throws Exception {
        this.follower = this.raftRule.getFollower().orElseThrow();
        this.raftRule.partition(this.follower);
        this.leader.getContext().setPreferSnapshotReplicationThreshold(1);
        long commitIndex = this.raftRule.appendEntries(2);
        this.raftRule.takeSnapshot(this.leader, commitIndex, numberOfChunks);
        this.raftRule.appendEntry();
    }

    private static class TimingOutResponseInterceptor
    implements TestRaftServerProtocol.ResponseInterceptor<InstallResponse> {
        private int count = 0;
        private final int timeoutAtRequest;

        public TimingOutResponseInterceptor(int timeoutAtRequest) {
            this.timeoutAtRequest = timeoutAtRequest;
        }

        @Override
        public CompletableFuture<InstallResponse> apply(InstallResponse installResponse) {
            ++this.count;
            if (this.count == this.timeoutAtRequest) {
                return CompletableFuture.failedFuture(new TimeoutException());
            }
            return CompletableFuture.completedFuture(installResponse);
        }

        int getCount() {
            return this.count;
        }
    }

    private static class RejectingInterceptor
    implements TestRaftServerProtocol.ResponseInterceptor<InstallResponse> {
        private int count = 0;
        private final int rejectAtChunk;

        public RejectingInterceptor(int rejectAtChunk) {
            this.rejectAtChunk = rejectAtChunk;
        }

        @Override
        public CompletableFuture<InstallResponse> apply(InstallResponse installResponse) {
            ++this.count;
            if (this.count == this.rejectAtChunk) {
                InstallResponse rejectionResponse = ((InstallResponse.Builder)((InstallResponse.Builder)InstallResponse.builder().withError(RaftError.Type.PROTOCOL_ERROR)).withStatus(RaftResponse.Status.ERROR)).build();
                return CompletableFuture.completedFuture(rejectionResponse);
            }
            return CompletableFuture.completedFuture(installResponse);
        }
    }

    private static class TimingOutRequestInterceptor
    implements Function<InstallRequest, CompletableFuture<Void>> {
        private int count = 0;
        private final int timeoutAtRequest;

        public TimingOutRequestInterceptor(int timeoutAtRequest) {
            this.timeoutAtRequest = timeoutAtRequest;
        }

        int getCount() {
            return this.count;
        }

        @Override
        public CompletableFuture<Void> apply(InstallRequest installRequest) {
            ++this.count;
            if (this.count == this.timeoutAtRequest) {
                return CompletableFuture.failedFuture(new TimeoutException());
            }
            return CompletableFuture.completedFuture(null);
        }
    }
}

