/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft;

import io.atomix.cluster.MemberId;
import io.atomix.raft.RaftRule;
import io.atomix.raft.RaftServer;
import io.atomix.raft.partition.RaftElectionConfig;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RaftPriorityElectionTest {
    @Rule
    @Parameterized.Parameter
    public RaftRule raftRule;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Object[][] raftConfigurations() {
        return new Object[][]{{RaftRule.withBootstrappedNodes(3, new RaftRule.Configurator(){

            @Override
            public void configure(MemberId id, RaftServer.Builder builder) {
                builder.withElectionConfig(RaftElectionConfig.ofPriorityElection((int)3, (int)(Integer.parseInt((String)((Object)id.id())) + 1)));
            }
        })}, {RaftRule.withBootstrappedNodes(4, new RaftRule.Configurator(){

            @Override
            public void configure(MemberId id, RaftServer.Builder builder) {
                builder.withElectionConfig(RaftElectionConfig.ofPriorityElection((int)4, (int)(Integer.parseInt((String)((Object)id.id())) + 1)));
            }
        })}, {RaftRule.withBootstrappedNodes(5, new RaftRule.Configurator(){

            @Override
            public void configure(MemberId id, RaftServer.Builder builder) {
                builder.withElectionConfig(RaftElectionConfig.ofPriorityElection((int)5, (int)(Integer.parseInt((String)((Object)id.id())) + 1)));
            }
        })}};
    }

    @Test
    public void shouldElectNewLeadersWhenLeaderUnavailable() throws Throwable {
        int failureTolerance = (this.raftRule.getMemberIds().size() - 1) / 2;
        for (int i = 0; i < failureTolerance; ++i) {
            this.raftRule.appendEntries(1);
            this.raftRule.shutdownLeader();
            this.raftRule.awaitNewLeader();
        }
    }
}

