/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft;

import io.atomix.cluster.MemberId;
import io.atomix.raft.RaftRule;
import io.atomix.raft.RaftServer;
import io.atomix.raft.partition.RaftElectionConfig;
import io.atomix.raft.storage.RaftStorage;
import io.atomix.raft.storage.log.RaftLogFlusher;
import io.camunda.zeebe.journal.CheckedJournalException;
import io.camunda.zeebe.journal.Journal;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record FaultyFlusherConfigurator(int faultyFlusherNumber, Supplier<Boolean> faultyWhen, Runnable notifyFaultyFlush, boolean leaderFaulty, boolean withDataLoss) implements RaftRule.Configurator
{
    private static final Logger LOG = LoggerFactory.getLogger(FaultyFlusherConfigurator.class);

    private RaftLogFlusher.Factory faultyFlusher(final Supplier<Boolean> faultyWhen, final Runnable notifyFaultyFlush) {
        return ignored -> new RaftLogFlusher(){

            public void flush(Journal journal) throws CheckedJournalException.FlushException {
                if (((Boolean)faultyWhen.get()).booleanValue()) {
                    notifyFaultyFlush.run();
                    if (FaultyFlusherConfigurator.this.withDataLoss) {
                        journal.deleteAfter(journal.getLastIndex() - 1L);
                    }
                    throw new CheckedJournalException.FlushException(new IOException("Failed sync"));
                }
                journal.flush();
            }
        };
    }

    @Override
    public void configure(MemberId id, RaftServer.Builder builder) {
        int nodePriority;
        int numericId = Integer.parseInt((String)((Object)id.id()));
        if (numericId <= this.faultyFlusherNumber) {
            LOG.trace("failing flusher for member {}", (Object)id);
            RaftStorage storage = builder.storage;
            Objects.requireNonNull(storage);
            builder.withStorage(RaftStorage.builder().withDirectory(storage.directory()).withSnapshotStore(storage.getPersistedSnapshotStore()).withFlusherFactory(this.faultyFlusher(this.faultyWhen, this.notifyFaultyFlush)).build());
            nodePriority = this.leaderFaulty ? Math.max(5 - numericId, 2) : numericId;
        } else {
            LOG.trace("not failing flusher for member {} ", (Object)id);
            nodePriority = this.leaderFaulty ? numericId : Math.max(5 - numericId, 2);
        }
        builder.withElectionConfig(RaftElectionConfig.ofPriorityElection((int)5, (int)nodePriority));
    }
}

