/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging.impl;

import com.google.common.collect.Maps;
import io.atomix.cluster.messaging.ManagedMessagingService;
import io.atomix.cluster.messaging.impl.TestMessagingService;
import io.atomix.utils.net.Address;
import java.util.Map;

public class TestMessagingServiceFactory {
    private final Map<Address, TestMessagingService> services = Maps.newConcurrentMap();

    public void partition(Address address) {
        TestMessagingService service = this.services.get(address);
        this.services.values().stream().filter(s -> !s.address().equals((Object)address)).forEach(s -> {
            service.partition(s.address());
            s.partition(service.address());
        });
    }

    public void heal(Address address) {
        TestMessagingService service = this.services.get(address);
        this.services.values().stream().filter(s -> !s.address().equals((Object)address)).forEach(s -> {
            service.heal(s.address());
            s.heal(service.address());
        });
    }

    public void partition(Address address1, Address address2) {
        TestMessagingService service1 = this.services.get(address1);
        TestMessagingService service2 = this.services.get(address2);
        service1.partition(service2.address());
        service2.partition(service1.address());
    }

    public void heal(Address address1, Address address2) {
        TestMessagingService service1 = this.services.get(address1);
        TestMessagingService service2 = this.services.get(address2);
        service1.heal(service2.address());
        service2.heal(service1.address());
    }

    public ManagedMessagingService newMessagingService(Address address) {
        return new TestMessagingService(address, this.services);
    }
}

