/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging.impl;

import io.atomix.cluster.messaging.MessagingConfig;
import io.atomix.cluster.messaging.MessagingException;
import io.atomix.cluster.messaging.impl.NettyMessagingService;
import io.atomix.utils.net.Address;
import io.camunda.zeebe.test.util.socket.SocketUtil;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import java.security.cert.CertificateException;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

final class NettyMessagingServiceTlsTest {
    NettyMessagingServiceTlsTest() {
    }

    @Test
    void shouldCommunicateOverTls() throws CertificateException {
        SelfSignedCertificate certificate = new SelfSignedCertificate();
        NettyMessagingService client = this.createSecureMessagingService(certificate);
        NettyMessagingService server = this.createSecureMessagingService(certificate);
        byte[] payload = "foo".getBytes();
        client.start().join();
        server.start().join();
        server.registerHandler("topic", (sender, request) -> CompletableFuture.completedFuture((new String((byte[])request) + "bar").getBytes()));
        byte[] response = (byte[])client.sendAndReceive(server.address(), "topic", payload).join();
        Assertions.assertThat((byte[])response).isEqualTo((Object)"foobar".getBytes());
    }

    @Test
    void shouldFailWhenClientIsNotUsingTls() throws CertificateException {
        SelfSignedCertificate certificate = new SelfSignedCertificate();
        NettyMessagingService client = this.createInsecureMessagingService();
        NettyMessagingService server = this.createSecureMessagingService(certificate);
        byte[] payload = "foo".getBytes();
        client.start().join();
        server.start().join();
        server.registerHandler("topic", (sender, request) -> CompletableFuture.completedFuture((new String((byte[])request) + "bar").getBytes()));
        CompletableFuture response = client.sendAndReceive(server.address(), "topic", payload, true, Duration.ofSeconds(10L));
        Assertions.assertThat((CompletableFuture)response).failsWithin(Duration.ofSeconds(10L)).withThrowableOfType(ExecutionException.class).havingRootCause().isInstanceOf(MessagingException.ConnectionClosed.class);
    }

    @Test
    void shouldFailWhenServerIsNotUsingTls() throws CertificateException {
        SelfSignedCertificate certificate = new SelfSignedCertificate();
        NettyMessagingService server = this.createInsecureMessagingService();
        NettyMessagingService client = this.createSecureMessagingService(certificate);
        byte[] payload = "foo".getBytes();
        client.start().join();
        server.start().join();
        server.registerHandler("topic", (sender, request) -> CompletableFuture.completedFuture((new String((byte[])request) + "bar").getBytes()));
        CompletableFuture response = client.sendAndReceive(server.address(), "topic", payload, true, Duration.ofSeconds(1L));
        Assertions.assertThat((CompletableFuture)response).failsWithin(Duration.ofSeconds(2L)).withThrowableOfType(ExecutionException.class).havingRootCause().isInstanceOf(MessagingException.ConnectionClosed.class);
    }

    private NettyMessagingService createInsecureMessagingService() {
        MessagingConfig config = new MessagingConfig().setPort(Integer.valueOf(SocketUtil.getNextAddress().getPort())).setTlsEnabled(false);
        return new NettyMessagingService("cluster", Address.from((int)config.getPort()), config, "insecureTestPrefix");
    }

    private NettyMessagingService createSecureMessagingService(SelfSignedCertificate certificate) {
        MessagingConfig config = new MessagingConfig().setPort(Integer.valueOf(SocketUtil.getNextAddress().getPort())).setTlsEnabled(true).setCertificateChain(certificate.certificate()).setPrivateKey(certificate.privateKey());
        return new NettyMessagingService("cluster", Address.from((int)config.getPort()), config, "secureTestPrefix");
    }
}

