/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.storage.system;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.cluster.MemberId;
import io.atomix.raft.metrics.MetaStoreMetrics;
import io.atomix.raft.storage.RaftStorage;
import io.atomix.raft.storage.StorageException;
import io.atomix.raft.storage.serializer.MetaEncoder;
import io.atomix.raft.storage.serializer.MetaStoreSerializer;
import io.atomix.raft.storage.system.Configuration;
import io.atomix.raft.storage.system.MetaStoreRecord;
import io.camunda.zeebe.journal.JournalMetaStore;
import io.prometheus.client.Histogram;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaStore
implements JournalMetaStore,
AutoCloseable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final FileChannel configurationChannel;
    private final File confFile;
    private final MetaStoreSerializer serializer = new MetaStoreSerializer();
    private final FileChannel metaFileChannel;
    private final MetaStoreMetrics metrics;
    private volatile long lastFlushedIndex;
    private volatile long commitIndex;

    public MetaStore(RaftStorage storage) throws IOException {
        if (!storage.directory().isDirectory() && !storage.directory().mkdirs()) {
            throw new IllegalArgumentException(String.format("Can't create storage directory [%s].", storage.directory()));
        }
        this.metrics = new MetaStoreMetrics(String.valueOf(storage.partitionId()));
        File metaFile = new File(storage.directory(), String.format("%s.meta", storage.prefix()));
        MetaStoreRecord record = null;
        boolean initFromFile = metaFile.exists();
        if (!initFromFile) {
            Files.write(metaFile.toPath(), new byte[32], StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE, StandardOpenOption.SYNC);
            this.lastFlushedIndex = MetaEncoder.lastFlushedIndexNullValue();
            this.commitIndex = MetaEncoder.commitIndexNullValue();
            record = new MetaStoreRecord(0L, this.lastFlushedIndex, this.commitIndex, "");
        }
        this.metaFileChannel = FileChannel.open(metaFile.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.DSYNC);
        if (initFromFile) {
            this.readMetaFromFile();
            record = this.serializer.readRecord();
            this.lastFlushedIndex = record.lastFlushedIndex();
            this.commitIndex = record.commitIndex();
        }
        this.initializeMetaBuffer(record);
        this.confFile = new File(storage.directory(), String.format("%s.conf", storage.prefix()));
        if (!this.confFile.exists()) {
            Files.write(this.confFile.toPath(), new byte[32], StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE, StandardOpenOption.SYNC);
        }
        this.configurationChannel = FileChannel.open(this.confFile.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE);
    }

    public synchronized void storeTerm(long term) {
        this.log.trace("Store term {}", (Object)term);
        this.serializer.writeTerm(term);
        this.writeToFile(this.serializer.metaByteBuffer(), this.metaFileChannel, false);
    }

    public synchronized long loadTerm() {
        this.readMetaFromFile();
        return this.serializer.readTerm();
    }

    public synchronized void storeVote(MemberId vote) {
        this.log.trace("Store vote {}", (Object)vote);
        String id = vote == null ? null : (String)((Object)vote.id());
        this.serializer.writeVotedFor(id);
        this.writeToFile(this.serializer.metaByteBuffer(), this.metaFileChannel, false);
    }

    public synchronized MemberId loadVote() {
        this.readMetaFromFile();
        String id = this.serializer.readVotedFor();
        return id.isEmpty() ? null : MemberId.from(id);
    }

    public synchronized void storeLastFlushedIndex(long index) {
        if (index == this.lastFlushedIndex) {
            this.log.trace("Skip storing same last flushed index {}", (Object)index);
            return;
        }
        this.log.trace("Store last flushed index {} and commitIndex {}", (Object)index, (Object)this.commitIndex);
        try (Histogram.Timer ignored = this.metrics.observeLastFlushedIndexUpdate();){
            this.serializer.writeLastFlushedIndex(index);
            this.writeToFile(this.serializer.metaByteBuffer(), this.metaFileChannel, false);
            this.lastFlushedIndex = index;
        }
    }

    public long loadLastFlushedIndex() {
        return this.lastFlushedIndex;
    }

    public void resetLastFlushedIndex() {
        this.storeLastFlushedIndex(MetaEncoder.lastFlushedIndexNullValue());
    }

    public boolean hasLastFlushedIndex() {
        return this.lastFlushedIndex != MetaEncoder.lastFlushedIndexNullValue();
    }

    public void storeCommitIndex(long index) {
        Preconditions.checkArgument((index >= 0L ? 1 : 0) != 0, (Object)"commit index must be >= 0");
        if (index == this.commitIndex) {
            this.log.trace("Skip storing same last flushed commit index {}", (Object)index);
            return;
        }
        this.commitIndex = index;
        this.serializer.writeCommitIndex(index);
    }

    public boolean hasCommitIndex() {
        return this.commitIndex != MetaEncoder.commitIndexNullValue();
    }

    public long commitIndex() {
        return this.commitIndex;
    }

    public synchronized void storeConfiguration(Configuration configuration) {
        this.log.trace("Store configuration {}", (Object)configuration);
        ByteBuffer buffer = this.serializer.writeConfiguration(configuration);
        this.writeToFile(buffer, this.configurationChannel, true);
    }

    public synchronized Configuration loadConfiguration() {
        try {
            this.configurationChannel.position(0L);
            ByteBuffer buffer = ByteBuffer.allocate((int)this.confFile.length());
            this.configurationChannel.read(buffer);
            buffer.position(0);
            return this.serializer.readConfiguration(buffer);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public synchronized void close() {
        try {
            try {
                this.writeToFile(this.serializer.metaByteBuffer(), this.metaFileChannel, true);
            }
            catch (Exception e) {
                this.log.warn("Failed to write to metaStore before closing", (Throwable)e);
            }
            this.metaFileChannel.close();
            this.configurationChannel.close();
        }
        catch (IOException e) {
            this.log.warn("Failed to close metastore", (Throwable)e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).toString();
    }

    private void initializeMetaBuffer(MetaStoreRecord record) {
        this.serializer.writeRecord(record);
        this.writeToFile(this.serializer.metaByteBuffer(), this.metaFileChannel, true);
    }

    private void readMetaFromFile() {
        try {
            this.metaFileChannel.read(this.serializer.metaByteBuffer(), 0L);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    private void writeToFile(ByteBuffer buffer, FileChannel file, boolean force) {
        try {
            buffer.position(0);
            file.write(buffer, 0L);
            if (force) {
                file.force(true);
            }
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }
}

