/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.storage.serializer;

import io.atomix.cluster.MemberId;
import io.atomix.raft.cluster.RaftMember;
import io.atomix.raft.cluster.impl.DefaultRaftMember;
import io.atomix.raft.storage.serializer.BooleanType;
import io.atomix.raft.storage.serializer.ConfigurationDecoder;
import io.atomix.raft.storage.serializer.ConfigurationEncoder;
import io.atomix.raft.storage.serializer.MessageHeaderDecoder;
import io.atomix.raft.storage.serializer.MessageHeaderEncoder;
import io.atomix.raft.storage.serializer.MetaDecoder;
import io.atomix.raft.storage.serializer.MetaEncoder;
import io.atomix.raft.storage.serializer.SerializerUtil;
import io.atomix.raft.storage.system.Configuration;
import io.atomix.raft.storage.system.MetaStoreRecord;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Instant;
import java.util.ArrayList;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class MetaStoreSerializer {
    private static final byte VERSION = 1;
    private static final int VERSION_LENGTH = 1;
    private final ByteBuffer metaByteBuffer = ByteBuffer.allocate(256).order(ByteOrder.LITTLE_ENDIAN);
    private final UnsafeBuffer metaBuffer = new UnsafeBuffer(this.metaByteBuffer);
    private final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
    private final ConfigurationEncoder configurationEncoder = new ConfigurationEncoder();
    private final MetaEncoder metaEncoder = new MetaEncoder();
    private final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    private final ConfigurationDecoder configurationDecoder = new ConfigurationDecoder();
    private final MetaDecoder metaDecoder = new MetaDecoder();

    public MetaStoreSerializer() {
        this.metaBuffer.putByte(0, (byte)1);
    }

    public ByteBuffer metaByteBuffer() {
        return this.metaByteBuffer.position(0);
    }

    public final ByteBuffer writeConfiguration(Configuration configuration) {
        ExpandableArrayBuffer buffer = new ExpandableArrayBuffer(256);
        buffer.putByte(0, (byte)1);
        this.configurationEncoder.wrapAndApplyHeader((MutableDirectBuffer)buffer, 1, this.headerEncoder);
        this.configurationEncoder.index(configuration.index()).term(configuration.term()).timestamp(configuration.time()).force(configuration.force() ? BooleanType.TRUE : BooleanType.FALSE);
        ConfigurationEncoder.NewMembersEncoder newMembersEncoder = this.configurationEncoder.newMembersCount(configuration.newMembers().size());
        for (RaftMember raftMember : configuration.newMembers()) {
            String memberId = (String)((Object)raftMember.memberId().id());
            newMembersEncoder.next().type(SerializerUtil.getSBEType(raftMember.getType())).updated(raftMember.getLastUpdated().toEpochMilli()).memberId(memberId);
        }
        ConfigurationEncoder.OldMembersEncoder oldMembersEncoder = this.configurationEncoder.oldMembersCount(configuration.oldMembers().size());
        for (RaftMember member : configuration.oldMembers()) {
            String memberId = (String)((Object)member.memberId().id());
            oldMembersEncoder.next().type(SerializerUtil.getSBEType(member.getType())).updated(member.getLastUpdated().toEpochMilli()).memberId(memberId);
        }
        int n = 1 + this.headerEncoder.encodedLength() + this.configurationEncoder.encodedLength();
        ByteBuffer bb = ByteBuffer.allocateDirect(n);
        buffer.getBytes(0, bb, n);
        return bb;
    }

    public Configuration readConfiguration(ByteBuffer bb) {
        UnsafeBuffer buffer = new UnsafeBuffer(bb);
        try {
            this.configurationDecoder.wrapAndApplyHeader((DirectBuffer)buffer, 1, this.headerDecoder);
        }
        catch (IllegalStateException e) {
            return null;
        }
        long index = this.configurationDecoder.index();
        long term = this.configurationDecoder.term();
        long timestamp = this.configurationDecoder.timestamp();
        boolean force = BooleanType.TRUE.equals((Object)this.configurationDecoder.force());
        ConfigurationDecoder.NewMembersDecoder newMembersDecoder = this.configurationDecoder.newMembers();
        ArrayList<RaftMember> newMembers = new ArrayList<RaftMember>(newMembersDecoder.count());
        for (ConfigurationDecoder.NewMembersDecoder member : newMembersDecoder) {
            RaftMember.Type type = SerializerUtil.getRaftMemberType(member.type());
            Instant updated = Instant.ofEpochMilli(member.updated());
            String memberId = member.memberId();
            newMembers.add(new DefaultRaftMember(MemberId.from(memberId), type, updated));
        }
        ConfigurationDecoder.OldMembersDecoder oldMembersDecoder = this.configurationDecoder.oldMembers();
        ArrayList<RaftMember> oldMembers = new ArrayList<RaftMember>(oldMembersDecoder.count());
        for (ConfigurationDecoder.OldMembersDecoder member : oldMembersDecoder) {
            RaftMember.Type type = SerializerUtil.getRaftMemberType(member.type());
            Instant updated = Instant.ofEpochMilli(member.updated());
            String memberId = member.memberId();
            oldMembers.add(new DefaultRaftMember(MemberId.from(memberId), type, updated));
        }
        return new Configuration(index, term, timestamp, newMembers, oldMembers, force);
    }

    public void writeTerm(long term) {
        this.metaEncoder.wrapAndApplyHeader((MutableDirectBuffer)this.metaBuffer, 1, this.headerEncoder);
        this.metaEncoder.term(term);
    }

    public long readTerm() {
        this.metaDecoder.wrapAndApplyHeader((DirectBuffer)this.metaBuffer, 1, this.headerDecoder);
        return this.metaDecoder.term();
    }

    public void writeVotedFor(String memberId) {
        this.metaEncoder.wrapAndApplyHeader((MutableDirectBuffer)this.metaBuffer, 1, this.headerEncoder);
        this.metaEncoder.votedFor(memberId);
    }

    public String readVotedFor() {
        this.metaDecoder.wrapAndApplyHeader((DirectBuffer)this.metaBuffer, 1, this.headerDecoder);
        return this.metaDecoder.votedFor();
    }

    public long readLastFlushedIndex() {
        this.metaDecoder.wrapAndApplyHeader((DirectBuffer)this.metaBuffer, 1, this.headerDecoder);
        return this.metaDecoder.lastFlushedIndex();
    }

    public void writeLastFlushedIndex(long index) {
        this.metaEncoder.wrapAndApplyHeader((MutableDirectBuffer)this.metaBuffer, 1, this.headerEncoder);
        this.metaEncoder.lastFlushedIndex(index);
    }

    public void writeCommitIndex(long index) {
        this.metaEncoder.wrapAndApplyHeader((MutableDirectBuffer)this.metaBuffer, 1, this.headerEncoder);
        this.metaEncoder.commitIndex(index);
    }

    public MetaStoreRecord readRecord() {
        this.metaDecoder.wrapAndApplyHeader((DirectBuffer)this.metaBuffer, 1, this.headerDecoder);
        long term = this.metaDecoder.term();
        long lastFlushedIndex = this.metaDecoder.lastFlushedIndex();
        long commitIndex = this.commitIndexOrDefault(this.metaDecoder.commitIndex());
        String votedFor = this.metaDecoder.votedForLength() == 0 ? null : this.metaDecoder.votedFor();
        return new MetaStoreRecord(term, lastFlushedIndex, commitIndex, votedFor);
    }

    public void writeRecord(MetaStoreRecord record) {
        this.metaEncoder.wrapAndApplyHeader((MutableDirectBuffer)this.metaBuffer, 1, this.headerEncoder);
        this.metaEncoder.term(record.term()).lastFlushedIndex(record.lastFlushedIndex()).commitIndex(record.commitIndex()).votedFor(record.votedFor());
    }

    private long commitIndexOrDefault(long serializedCommitIndex) {
        return serializedCommitIndex == MetaDecoder.commitIndexNullValue() ? 0L : serializedCommitIndex;
    }
}

