/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.storage.log;

import io.atomix.utils.concurrent.ThreadContextFactory;
import io.camunda.zeebe.journal.CheckedJournalException;
import io.camunda.zeebe.journal.Journal;
import io.camunda.zeebe.util.CloseableSilently;

@FunctionalInterface
public interface RaftLogFlusher
extends CloseableSilently {
    public void flush(Journal var1) throws CheckedJournalException.FlushException;

    default public boolean isDirect() {
        return false;
    }

    default public void close() {
    }

    @FunctionalInterface
    public static interface Factory {
        public static final DirectFlusher DIRECT = new DirectFlusher();
        public static final NoopFlusher NOOP = new NoopFlusher();

        public RaftLogFlusher createFlusher(ThreadContextFactory var1);

        public static DirectFlusher direct(ThreadContextFactory ignored) {
            return DIRECT;
        }

        public static NoopFlusher noop(ThreadContextFactory ignored) {
            return NOOP;
        }
    }

    public static final class DirectFlusher
    implements RaftLogFlusher {
        @Override
        public void flush(Journal journal) throws CheckedJournalException.FlushException {
            journal.flush();
        }

        @Override
        public boolean isDirect() {
            return true;
        }
    }

    public static final class NoopFlusher
    implements RaftLogFlusher {
        @Override
        public void flush(Journal ignoredJournal) {
        }
    }
}

