/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.storage.log;

import io.atomix.raft.storage.log.RaftLogFlusher;
import io.atomix.utils.concurrent.Scheduled;
import io.atomix.utils.concurrent.Scheduler;
import io.camunda.zeebe.journal.CheckedJournalException;
import io.camunda.zeebe.journal.Journal;
import io.camunda.zeebe.journal.JournalException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DelayedFlusher
implements RaftLogFlusher {
    private static final Logger LOGGER = LoggerFactory.getLogger(DelayedFlusher.class);
    private final Scheduler scheduler;
    private final Duration delayTime;
    private final Object scheduledMonitor = new Object();
    private Scheduled scheduledFlush;
    private boolean closed;

    public DelayedFlusher(Scheduler scheduler, Duration delayTime) {
        this.scheduler = Objects.requireNonNull(scheduler, "must specify a scheduler");
        this.delayTime = Objects.requireNonNull(delayTime, "must specify a valid flush delay");
    }

    @Override
    public void flush(Journal journal) {
        this.scheduleFlush(journal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.scheduledMonitor;
        synchronized (object) {
            this.closed = true;
            if (this.scheduledFlush != null) {
                this.scheduledFlush.cancel();
                this.scheduledFlush = null;
            }
        }
        this.scheduler.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleFlush(Journal journal) {
        Object object = this.scheduledMonitor;
        synchronized (object) {
            if (this.closed) {
                LOGGER.debug("Skipped scheduling flush due to flusher being closed");
                return;
            }
            if (this.scheduledFlush == null) {
                LOGGER.trace("Scheduling delayed flush in {} up to index {}", (Object)this.delayTime, (Object)journal.getLastIndex());
                this.scheduledFlush = this.scheduler.schedule(this.delayTime, () -> this.asyncFlush(journal));
            } else {
                LOGGER.trace("Skipped scheduling flush as there is already a pending, scheduled flush");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncFlush(Journal journal) {
        Object object = this.scheduledMonitor;
        synchronized (object) {
            this.scheduledFlush = null;
        }
        LOGGER.trace("Flushing journal after {}", (Object)this.delayTime);
        try {
            journal.flush();
        }
        catch (CheckedJournalException | JournalException | UncheckedIOException e) {
            LOGGER.warn("Failed to flush journal, operation will be retried after {}", (Object)this.delayTime, (Object)e);
            this.scheduleFlush(journal);
        }
    }

    public String toString() {
        return "DelayedFlusher{scheduler=" + String.valueOf(this.scheduler) + ", delay=" + String.valueOf(this.delayTime) + ", scheduledFlush=" + String.valueOf(this.scheduledFlush) + "}";
    }
}

