/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.snapshot.impl;

import io.atomix.raft.snapshot.impl.MessageHeaderEncoder;
import io.atomix.raft.snapshot.impl.MetaAttribute;
import io.atomix.raft.snapshot.impl.SnapshotChunkDecoder;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.ArrayUtil;
import org.agrona.sbe.MessageEncoderFlyweight;

public final class SnapshotChunkEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 36;
    public static final int TEMPLATE_ID = 4;
    public static final int SCHEMA_ID = 6;
    public static final int SCHEMA_VERSION = 3;
    public static final String SEMANTIC_VERSION = "0.1.0";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final SnapshotChunkEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 36;
    }

    public int sbeTemplateId() {
        return 4;
    }

    public int sbeSchemaId() {
        return 6;
    }

    public int sbeSchemaVersion() {
        return 3;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public SnapshotChunkEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 36);
        return this;
    }

    public SnapshotChunkEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(36).templateId(4).schemaId(6).version(3);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int totalCountId() {
        return 0;
    }

    public static int totalCountSinceVersion() {
        return 0;
    }

    public static int totalCountEncodingOffset() {
        return 0;
    }

    public static int totalCountEncodingLength() {
        return 4;
    }

    public static String totalCountMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int totalCountNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int totalCountMinValue() {
        return -2147483647;
    }

    public static int totalCountMaxValue() {
        return Integer.MAX_VALUE;
    }

    public SnapshotChunkEncoder totalCount(int value) {
        this.buffer.putInt(this.offset + 0, value, BYTE_ORDER);
        return this;
    }

    public static int checksumId() {
        return 1;
    }

    public static int checksumSinceVersion() {
        return 0;
    }

    public static int checksumEncodingOffset() {
        return 4;
    }

    public static int checksumEncodingLength() {
        return 8;
    }

    public static String checksumMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long checksumNullValue() {
        return -1L;
    }

    public static long checksumMinValue() {
        return 0L;
    }

    public static long checksumMaxValue() {
        return -2L;
    }

    public SnapshotChunkEncoder checksum(long value) {
        this.buffer.putLong(this.offset + 4, value, BYTE_ORDER);
        return this;
    }

    public static int snapshotChecksumId() {
        return 5;
    }

    public static int snapshotChecksumSinceVersion() {
        return 2;
    }

    public static int snapshotChecksumEncodingOffset() {
        return 12;
    }

    public static int snapshotChecksumEncodingLength() {
        return 8;
    }

    public static String snapshotChecksumMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long snapshotChecksumNullValue() {
        return -1L;
    }

    public static long snapshotChecksumMinValue() {
        return 0L;
    }

    public static long snapshotChecksumMaxValue() {
        return -2L;
    }

    public SnapshotChunkEncoder snapshotChecksum(long value) {
        this.buffer.putLong(this.offset + 12, value, BYTE_ORDER);
        return this;
    }

    public static int fileBlockPositionId() {
        return 6;
    }

    public static int fileBlockPositionSinceVersion() {
        return 3;
    }

    public static int fileBlockPositionEncodingOffset() {
        return 20;
    }

    public static int fileBlockPositionEncodingLength() {
        return 8;
    }

    public static String fileBlockPositionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long fileBlockPositionNullValue() {
        return -1L;
    }

    public static long fileBlockPositionMinValue() {
        return 0L;
    }

    public static long fileBlockPositionMaxValue() {
        return -2L;
    }

    public SnapshotChunkEncoder fileBlockPosition(long value) {
        this.buffer.putLong(this.offset + 20, value, BYTE_ORDER);
        return this;
    }

    public static int totalFileSizeId() {
        return 7;
    }

    public static int totalFileSizeSinceVersion() {
        return 3;
    }

    public static int totalFileSizeEncodingOffset() {
        return 28;
    }

    public static int totalFileSizeEncodingLength() {
        return 8;
    }

    public static String totalFileSizeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long totalFileSizeNullValue() {
        return -1L;
    }

    public static long totalFileSizeMinValue() {
        return 0L;
    }

    public static long totalFileSizeMaxValue() {
        return -2L;
    }

    public SnapshotChunkEncoder totalFileSize(long value) {
        this.buffer.putLong(this.offset + 28, value, BYTE_ORDER);
        return this;
    }

    public static int snapshotIdId() {
        return 2;
    }

    public static String snapshotIdCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String snapshotIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int snapshotIdHeaderLength() {
        return 4;
    }

    public SnapshotChunkEncoder putSnapshotId(DirectBuffer src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public SnapshotChunkEncoder putSnapshotId(byte[] src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public SnapshotChunkEncoder snapshotId(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public static int chunkNameId() {
        return 3;
    }

    public static String chunkNameCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String chunkNameMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int chunkNameHeaderLength() {
        return 4;
    }

    public SnapshotChunkEncoder putChunkName(DirectBuffer src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public SnapshotChunkEncoder putChunkName(byte[] src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public SnapshotChunkEncoder chunkName(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public static int contentId() {
        return 4;
    }

    public static String contentMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int contentHeaderLength() {
        return 4;
    }

    public SnapshotChunkEncoder putContent(DirectBuffer src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public SnapshotChunkEncoder putContent(byte[] src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        SnapshotChunkDecoder decoder = new SnapshotChunkDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.offset, 36, 3);
        return decoder.appendTo(builder);
    }
}

