/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.partition.impl;

import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.MemberId;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.atomix.primitive.partition.PartitionMetadata;
import io.atomix.raft.RaftApplicationEntryCommittedPositionListener;
import io.atomix.raft.RaftCommitListener;
import io.atomix.raft.RaftRoleChangeListener;
import io.atomix.raft.RaftServer;
import io.atomix.raft.SnapshotReplicationListener;
import io.atomix.raft.cluster.RaftMember;
import io.atomix.raft.metrics.RaftStartupMetrics;
import io.atomix.raft.partition.RaftElectionConfig;
import io.atomix.raft.partition.RaftPartition;
import io.atomix.raft.partition.RaftPartitionConfig;
import io.atomix.raft.partition.RaftStorageConfig;
import io.atomix.raft.partition.impl.RaftNamespaces;
import io.atomix.raft.partition.impl.RaftServerCommunicator;
import io.atomix.raft.roles.RaftRole;
import io.atomix.raft.storage.RaftStorage;
import io.atomix.raft.storage.log.RaftLogReader;
import io.atomix.raft.zeebe.ZeebeLogAppender;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Serializer;
import io.camunda.zeebe.snapshots.PersistedSnapshotStore;
import io.camunda.zeebe.snapshots.ReceivableSnapshotStore;
import io.camunda.zeebe.util.FileUtil;
import io.camunda.zeebe.util.health.FailureListener;
import io.camunda.zeebe.util.health.HealthMonitorable;
import io.camunda.zeebe.util.health.HealthReport;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;

public class RaftPartitionServer
implements HealthMonitorable {
    private final Logger log;
    private final MemberId localMemberId;
    private final RaftPartition partition;
    private final RaftPartitionConfig config;
    private final ClusterMembershipService membershipService;
    private final ClusterCommunicationService clusterCommunicator;
    private final PartitionMetadata partitionMetadata;
    private final Duration requestTimeout;
    private final Duration snapshotRequestTimeout;
    private final Duration configurationChangeTimeout;
    private final ReceivableSnapshotStore persistedSnapshotStore;
    private final RaftServer server;

    public RaftPartitionServer(RaftPartition partition, RaftPartitionConfig config, MemberId localMemberId, ClusterMembershipService membershipService, ClusterCommunicationService clusterCommunicator, ReceivableSnapshotStore persistedSnapshotStore, PartitionMetadata partitionMetadata) {
        this.partition = partition;
        this.config = config;
        this.localMemberId = localMemberId;
        this.membershipService = membershipService;
        this.clusterCommunicator = clusterCommunicator;
        this.log = ContextualLoggerFactory.getLogger(this.getClass(), (LoggerContext)LoggerContext.builder(RaftPartitionServer.class).addValue((Object)partition.name()).build());
        this.persistedSnapshotStore = persistedSnapshotStore;
        this.partitionMetadata = partitionMetadata;
        this.requestTimeout = config.getRequestTimeout();
        this.snapshotRequestTimeout = config.getSnapshotRequestTimeout();
        this.configurationChangeTimeout = config.getConfigurationChangeTimeout();
        this.server = this.buildServer();
    }

    public CompletableFuture<RaftPartitionServer> bootstrap() {
        RaftStartupMetrics raftStartupMetrics = new RaftStartupMetrics(this.partition.name());
        this.log.info("Server bootstrapping partition {}", (Object)this.partition.id());
        long bootstrapStartTime = System.currentTimeMillis();
        return ((CompletableFuture)this.server.bootstrap(this.partition.members()).whenComplete((r, e) -> {
            if (e == null) {
                long endTime = System.currentTimeMillis();
                raftStartupMetrics.observeBootstrapDuration(endTime - bootstrapStartTime);
                this.log.info("Server successfully bootstrapped partition {} in {}ms", (Object)this.partition.id(), (Object)(endTime - bootstrapStartTime));
            } else {
                this.log.warn("Server bootstrap failed for partition {}", (Object)this.partition.id(), e);
            }
        })).thenApply(v -> this);
    }

    public CompletableFuture<RaftPartitionServer> join() {
        RaftStartupMetrics metrics = new RaftStartupMetrics(this.partition.name());
        long joinStartTime = System.currentTimeMillis();
        this.log.info("Server joining partition {}", (Object)this.partition.id());
        return ((CompletableFuture)this.server.join(this.partitionMetadata.members()).whenComplete((r, e) -> {
            if (e == null) {
                long endTime = System.currentTimeMillis();
                metrics.observeJoinDuration(endTime - joinStartTime);
                this.log.info("Server successfully joined partition {} in {}ms", (Object)this.partition.id(), (Object)(endTime - joinStartTime));
            } else {
                this.log.warn("Server join failed for partition {}", (Object)this.partition.id(), e);
            }
        })).thenApply(v -> this);
    }

    public CompletableFuture<RaftPartitionServer> leave() {
        return this.server.leave().thenApply(v -> this);
    }

    public CompletableFuture<RaftPartitionServer> forceReconfigure(Map<MemberId, RaftMember.Type> members) {
        return this.server.forceConfigure(members).thenApply(v -> this);
    }

    public CompletableFuture<Void> stop() {
        return this.server != null ? this.server.shutdown() : CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> reconfigurePriority(int newPriority) {
        return this.server.reconfigurePriority(newPriority);
    }

    private RaftServer buildServer() {
        Integer partitionId = (Integer)this.partition.id().id();
        RaftElectionConfig electionConfig = this.config.isPriorityElectionEnabled() ? RaftElectionConfig.ofPriorityElection(this.partitionMetadata.getTargetPriority(), this.partitionMetadata.getPriority(this.localMemberId)) : RaftElectionConfig.ofDefaultElection();
        return (RaftServer)RaftServer.builder(this.localMemberId).withName(this.partition.name()).withPartitionId(partitionId).withMembershipService(this.membershipService).withProtocol(this.createServerProtocol()).withPartitionConfig(this.config).withStorage(this.createRaftStorage()).withEntryValidator(this.config.getEntryValidator()).withElectionConfig(electionConfig).build();
    }

    public CompletableFuture<Void> flushLog() {
        return this.server.flushLog();
    }

    public RaftLogReader openReader() {
        return this.server.getContext().getLog().openCommittedReader();
    }

    public void addRoleChangeListener(RaftRoleChangeListener listener) {
        this.server.addRoleChangeListener(listener);
    }

    public String componentName() {
        return this.getClass().getSimpleName();
    }

    public HealthReport getHealthReport() {
        return this.server.getContext().getHealthReport();
    }

    public void addFailureListener(FailureListener listener) {
        this.server.addFailureListener(listener);
    }

    public void removeFailureListener(FailureListener listener) {
        this.server.removeFailureListener(listener);
    }

    public void removeRoleChangeListener(RaftRoleChangeListener listener) {
        this.server.removeRoleChangeListener(listener);
    }

    public void addCommitListener(RaftCommitListener commitListener) {
        this.server.getContext().addCommitListener(commitListener);
    }

    public void removeCommitListener(RaftCommitListener commitListener) {
        this.server.getContext().removeCommitListener(commitListener);
    }

    public void addCommittedEntryListener(RaftApplicationEntryCommittedPositionListener commitListener) {
        this.server.getContext().addCommittedEntryListener(commitListener);
    }

    public void removeCommittedEntryListener(RaftApplicationEntryCommittedPositionListener commitListener) {
        this.server.getContext().removeCommittedEntryListener(commitListener);
    }

    public void addSnapshotReplicationListener(SnapshotReplicationListener listener) {
        this.server.getContext().addSnapshotReplicationListener(listener);
    }

    public void removeSnapshotReplicationListener(SnapshotReplicationListener listener) {
        this.server.getContext().removeSnapshotReplicationListener(listener);
    }

    public PersistedSnapshotStore getPersistedSnapshotStore() {
        return this.persistedSnapshotStore;
    }

    public void delete() {
        try {
            FileUtil.deleteFolderIfExists((Path)this.partition.dataDirectory().toPath());
        }
        catch (IOException e) {
            this.log.error("Failed to delete partition: {}", (Object)this.partition, (Object)e);
        }
    }

    public Optional<ZeebeLogAppender> getAppender() {
        RaftRole role = this.server.getContext().getRaftRole();
        if (role instanceof ZeebeLogAppender) {
            return Optional.of((ZeebeLogAppender)((Object)role));
        }
        return Optional.empty();
    }

    public RaftServer.Role getRole() {
        return this.server.getRole();
    }

    public long getTerm() {
        return this.server.getTerm();
    }

    public MemberId getMemberId() {
        return this.localMemberId;
    }

    private RaftStorage createRaftStorage() {
        RaftStorageConfig storageConfig = this.config.getStorageConfig();
        return RaftStorage.builder().withPrefix(this.partition.name()).withPartitionId((Integer)this.partition.id().id()).withDirectory(this.partition.dataDirectory()).withMaxSegmentSize((int)storageConfig.getSegmentSize()).withFlusherFactory(storageConfig.flusherFactory()).withFreeDiskSpace(storageConfig.getFreeDiskSpace()).withSnapshotStore(this.persistedSnapshotStore).withJournalIndexDensity(storageConfig.getJournalIndexDensity()).withPreallocateSegmentFiles(storageConfig.isPreallocateSegmentFiles()).build();
    }

    private RaftServerCommunicator createServerProtocol() {
        return new RaftServerCommunicator(this.partition.name(), Serializer.using((Namespace)RaftNamespaces.RAFT_PROTOCOL), this.clusterCommunicator, this.requestTimeout, this.snapshotRequestTimeout, this.configurationChangeTimeout);
    }

    public CompletableFuture<Void> stepDown() {
        return this.server.stepDown();
    }

    public CompletableFuture<RaftServer> promote() {
        return this.server.promote();
    }

    public Collection<RaftMember> getMembers() {
        return this.server.cluster().getMembers();
    }

    public CompletableFuture<Collection<Path>> getTailSegments(long index) {
        return this.server.getContext().getTailSegments(index);
    }
}

