/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft;

import io.atomix.cluster.ClusterMembershipEventListener;
import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.Member;
import io.atomix.cluster.MemberId;
import io.atomix.raft.RaftServer;
import io.atomix.raft.cluster.RaftMember;
import io.atomix.raft.cluster.impl.DefaultRaftMember;
import io.atomix.raft.impl.RaftContext;
import io.atomix.raft.partition.RaftPartitionConfig;
import io.atomix.raft.protocol.RaftServerProtocol;
import io.atomix.raft.protocol.TestRaftProtocolFactory;
import io.atomix.raft.protocol.TestRaftServerProtocol;
import io.atomix.raft.roles.LeaderRole;
import io.atomix.raft.snapshot.InMemorySnapshot;
import io.atomix.raft.snapshot.TestSnapshotStore;
import io.atomix.raft.storage.RaftStorage;
import io.atomix.raft.storage.log.IndexedRaftLogEntry;
import io.atomix.raft.zeebe.ZeebeLogAppender;
import io.atomix.utils.concurrent.SingleThreadContext;
import io.atomix.utils.net.Address;
import io.camunda.zeebe.snapshots.ReceivableSnapshotStore;
import io.camunda.zeebe.util.FileUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.CompletableFutureAssert;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

final class ReconfigurationTest {
    private final SingleThreadContext context = new SingleThreadContext("raft-%d");
    private final TestRaftProtocolFactory protocolFactory = new TestRaftProtocolFactory();
    private final List<RaftServer> servers = new LinkedList<RaftServer>();

    ReconfigurationTest() {
    }

    @AfterEach
    void cleanup() {
        for (RaftServer server : this.servers) {
            server.shutdown().join();
        }
        this.context.close();
    }

    private static LeaderRole awaitLeader(RaftServer ... servers) {
        return (LeaderRole)((Optional)Awaitility.await((String)"Leader is known").until(() -> ReconfigurationTest.getLeader(servers), Optional::isPresent)).get();
    }

    private static void awaitNoLeader(RaftServer ... servers) {
        Awaitility.await((String)"There is no leader").until(() -> ReconfigurationTest.getLeader(servers), Optional::isEmpty);
    }

    private static Optional<LeaderRole> getLeader(RaftServer ... servers) {
        return Arrays.stream(servers).filter(RaftServer::isLeader).map(RaftServer::getContext).map(RaftContext::getRaftRole).map(LeaderRole.class::cast).findAny();
    }

    private static Optional<RaftServer> getFollower(RaftServer ... servers) {
        return Arrays.stream(servers).filter(RaftServer::isFollower).findAny();
    }

    private static AppendResult appendEntry(LeaderRole leader) {
        AppendResult result = new AppendResult();
        leader.appendEntry(-1L, -1L, ByteBuffer.wrap(new byte[0]), (ZeebeLogAppender.AppendListener)result);
        return result;
    }

    private ClusterMembershipService createMembershipService(MemberId localId, MemberId ... remoteIds) {
        final Member localMember = Member.member((MemberId)localId, (Address)Address.local());
        Stream<Member> remoteMembers = Arrays.stream(remoteIds).map(id -> Member.member((MemberId)id, (Address)Address.local()));
        final HashMap<MemberId, Member> members = new HashMap<MemberId, Member>();
        members.put(localId, localMember);
        remoteMembers.forEach(member -> members.put(member.id(), (Member)member));
        return new ClusterMembershipService(){

            public Member getLocalMember() {
                return localMember;
            }

            public Set<Member> getMembers() {
                return Set.copyOf(members.values());
            }

            public Member getMember(MemberId memberId) {
                return (Member)members.get(memberId);
            }

            public void addListener(ClusterMembershipEventListener listener) {
            }

            public void removeListener(ClusterMembershipEventListener listener) {
            }
        };
    }

    private RaftServer createServer(Path dir, ClusterMembershipService membershipService) {
        MemberId memberId = membershipService.getLocalMember().id();
        TestRaftServerProtocol protocol = this.protocolFactory.newServerProtocol(memberId);
        RaftStorage storage = RaftStorage.builder().withDirectory(dir.resolve(memberId.toString()).toFile()).withSnapshotStore((ReceivableSnapshotStore)new TestSnapshotStore(new AtomicReference<InMemorySnapshot>())).withMaxSegmentSize(10240).build();
        RaftServer server = (RaftServer)RaftServer.builder((MemberId)memberId).withMembershipService(membershipService).withProtocol((RaftServerProtocol)protocol).withStorage(storage).withPartitionConfig(new RaftPartitionConfig().setElectionTimeout(Duration.ofMillis(500L)).setHeartbeatInterval(Duration.ofMillis(100L))).build();
        this.servers.add(server);
        return server;
    }

    private static final class AppendResult
    implements ZeebeLogAppender.AppendListener {
        private final CompletableFuture<Long> write = new CompletableFuture();
        private final CompletableFuture<Long> commit = new CompletableFuture();

        private AppendResult() {
        }

        CompletableFuture<Long> commit() {
            return this.commit;
        }

        CompletableFuture<Long> write() {
            return this.write;
        }

        public void onWrite(IndexedRaftLogEntry indexed) {
            this.write.complete(indexed.index());
        }

        public void onWriteError(Throwable error) {
            this.write.completeExceptionally(error);
            this.commit.completeExceptionally(error);
        }

        public void onCommit(long index, long highestPosition) {
            this.commit.complete(index);
        }

        public void onCommitError(long index, Throwable error) {
            this.commit.completeExceptionally(error);
        }
    }

    @Nested
    class ForceConfigureTest {
        final MemberId id1 = MemberId.from((String)"1");
        final MemberId id2 = MemberId.from((String)"2");
        final MemberId id3 = MemberId.from((String)"3");
        final MemberId id4 = MemberId.from((String)"4");
        @TempDir
        private Path tmp;
        private RaftServer m1;
        private RaftServer m2;
        private RaftServer m3;
        private RaftServer m4;

        ForceConfigureTest() {
        }

        @BeforeEach
        void startServers() {
            this.m1 = ReconfigurationTest.this.createServer(this.tmp, ReconfigurationTest.this.createMembershipService(this.id1, this.id2, this.id3, this.id4));
            this.m2 = ReconfigurationTest.this.createServer(this.tmp, ReconfigurationTest.this.createMembershipService(this.id2, this.id1, this.id3, this.id4));
            this.m3 = ReconfigurationTest.this.createServer(this.tmp, ReconfigurationTest.this.createMembershipService(this.id3, this.id1, this.id2, this.id4));
            this.m4 = ReconfigurationTest.this.createServer(this.tmp, ReconfigurationTest.this.createMembershipService(this.id4, this.id1, this.id2, this.id3));
            CompletableFuture.allOf(this.m1.bootstrap(new MemberId[]{this.id1, this.id2, this.id3, this.id4}), this.m2.bootstrap(new MemberId[]{this.id1, this.id2, this.id3, this.id4}), this.m3.bootstrap(new MemberId[]{this.id1, this.id2, this.id3, this.id4}), this.m4.bootstrap(new MemberId[]{this.id1, this.id2, this.id3, this.id4})).join();
            ReconfigurationTest.awaitLeader(this.m1, this.m2, this.m3, this.m4);
        }

        @Test
        void shouldForceConfigureWhenMembersToRemoveAreActive() {
            this.m2.forceConfigure(this.newMembers()).join();
            ReconfigurationTest.awaitLeader(this.m1, this.m2);
            Assertions.assertThat(List.of(this.m1, this.m2)).allSatisfy(m -> ((AbstractCollectionAssert)Assertions.assertThat((Collection)m.cluster().getMembers()).describedAs("Force configuration should have only two members", new Object[0])).containsExactlyInAnyOrderElementsOf(Set.of(new DefaultRaftMember(this.id1, RaftMember.Type.ACTIVE, Instant.now()), new DefaultRaftMember(this.id2, RaftMember.Type.ACTIVE, Instant.now()))));
        }

        @Test
        void shouldForceConfigureWhenRemovedMembersAreUnreachable() {
            this.m3.shutdown().join();
            this.m4.shutdown().join();
            this.m2.forceConfigure(this.newMembers()).join();
            ReconfigurationTest.awaitLeader(this.m1, this.m2);
            Assertions.assertThat(List.of(this.m1, this.m2)).allSatisfy(m -> ((AbstractCollectionAssert)Assertions.assertThat((Collection)m.cluster().getMembers()).describedAs("Force configuration should have only two members", new Object[0])).containsExactlyInAnyOrderElementsOf(Set.of(new DefaultRaftMember(this.id1, RaftMember.Type.ACTIVE, Instant.now()), new DefaultRaftMember(this.id2, RaftMember.Type.ACTIVE, Instant.now()))));
        }

        @Test
        void shouldForceConfigureIfOnlyOneRemainingMember() {
            this.m2.shutdown().join();
            this.m3.shutdown().join();
            this.m4.shutdown().join();
            this.m1.forceConfigure(Map.of(this.id1, RaftMember.Type.ACTIVE)).join();
            ReconfigurationTest.awaitLeader(this.m1);
            ((AbstractCollectionAssert)Assertions.assertThat((Collection)this.m1.cluster().getMembers()).describedAs("Force configuration should have only one members", new Object[0])).containsExactlyInAnyOrderElementsOf(Set.of(new DefaultRaftMember(this.id1, RaftMember.Type.ACTIVE, Instant.now())));
        }

        @Test
        void shouldFailForceConfigurationIfOneMemberUnreachable() {
            this.m2.shutdown().join();
            Assertions.assertThat((CompletableFuture)this.m1.forceConfigure(this.newMembers())).failsWithin(Duration.ofSeconds(10L)).withThrowableOfType(ExecutionException.class).withMessageContaining("Failed to force configure because not all members acknowledged the request.");
        }

        @Test
        void shouldForceConfigureWhenRetriedAfterFailure() {
            this.m2.shutdown().join();
            CompletableFuture firstAttempt = this.m1.forceConfigure(this.newMembers());
            Assertions.assertThat((CompletableFuture)firstAttempt).failsWithin(Duration.ofSeconds(10L)).withThrowableOfType(ExecutionException.class).withMessageContaining("Failed to force configure because not all members acknowledged the request.");
            RaftServer m2Restarted = ReconfigurationTest.this.createServer(this.tmp, ReconfigurationTest.this.createMembershipService(this.id2, this.id1, this.id3, this.id4));
            m2Restarted.bootstrap(new MemberId[]{this.id1, this.id2, this.id3, this.id4}).join();
            CompletableFuture secondAttempt = this.m1.forceConfigure(this.newMembers());
            Assertions.assertThat((CompletableFuture)secondAttempt).succeedsWithin(Duration.ofSeconds(10L));
        }

        @Test
        void canCommitNewEventsAfterForceConfigure() {
            this.m2.forceConfigure(this.newMembers()).join();
            this.m3.shutdown().join();
            this.m4.shutdown().join();
            LeaderRole leader = ReconfigurationTest.awaitLeader(this.m1, this.m2);
            CompletableFuture<Long> commitFuture = ReconfigurationTest.appendEntry(leader).commit();
            Assertions.assertThat(commitFuture).succeedsWithin(Duration.ofMillis(1000L));
        }

        @Test
        void shouldReconfigureViaAnOutDatedFollower() {
            this.m2.shutdown().join();
            LeaderRole leader = ReconfigurationTest.awaitLeader(this.m1, this.m3, this.m4);
            ReconfigurationTest.appendEntry(leader).commit().join();
            this.m3.shutdown().join();
            this.m4.shutdown().join();
            ReconfigurationTest.awaitNoLeader(this.m1);
            RaftServer m2Restarted = ReconfigurationTest.this.createServer(this.tmp, ReconfigurationTest.this.createMembershipService(this.id2, this.id1, this.id3, this.id4));
            m2Restarted.bootstrap(new MemberId[]{this.id1, this.id2, this.id3, this.id4});
            m2Restarted.forceConfigure(this.newMembers()).join();
            ReconfigurationTest.awaitLeader(this.m1, m2Restarted);
        }

        @Test
        void forceReconfigureIsIdempotentWhenRetriedViaAFollower() {
            this.m2.forceConfigure(this.newMembers()).join();
            this.m3.shutdown().join();
            this.m4.shutdown().join();
            ReconfigurationTest.awaitLeader(this.m1, this.m2);
            Awaitility.await((String)"Both members have come out of force configuration").untilAsserted(() -> {
                Assertions.assertThat((boolean)this.m2.getContext().getCluster().getConfiguration().force()).isFalse();
                Assertions.assertThat((boolean)this.m1.getContext().getCluster().getConfiguration().force()).isFalse();
            });
            RaftServer follower = ReconfigurationTest.getFollower(this.m1, this.m2).orElseThrow();
            follower.forceConfigure(this.newMembers()).join();
            Awaitility.await((String)"Both members have come out of force configuration").untilAsserted(() -> {
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.m2.getContext().getCluster().getConfiguration().force()).describedAs("Member 2 has come out of force configuration", new Object[0])).isFalse();
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.m1.getContext().getCluster().getConfiguration().force()).describedAs("Member 1 has come out of force configuration", new Object[0])).isFalse();
            });
        }

        @Test
        void forceReconfigureIsIdempotentWhenRetriedViaLeader() {
            this.m2.forceConfigure(this.newMembers()).join();
            this.m3.shutdown().join();
            this.m4.shutdown().join();
            ReconfigurationTest.awaitLeader(this.m1, this.m2);
            Awaitility.await((String)"Both members have come out of force configuration").untilAsserted(() -> {
                Assertions.assertThat((boolean)this.m2.getContext().getCluster().getConfiguration().force()).isFalse();
                Assertions.assertThat((boolean)this.m1.getContext().getCluster().getConfiguration().force()).isFalse();
            });
            RaftServer leader = Stream.of(this.m1, this.m2).filter(RaftServer::isLeader).findAny().orElseThrow();
            leader.forceConfigure(this.newMembers()).join();
            Awaitility.await((String)"Both members have come out of force configuration").untilAsserted(() -> {
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.m2.getContext().getCluster().getConfiguration().force()).describedAs("Member 2 has come out of force configuration", new Object[0])).isFalse();
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.m1.getContext().getCluster().getConfiguration().force()).describedAs("Member 1 has come out of force configuration", new Object[0])).isFalse();
            });
        }

        private Map<MemberId, RaftMember.Type> newMembers() {
            return Map.of(this.id1, RaftMember.Type.ACTIVE, this.id2, RaftMember.Type.ACTIVE);
        }
    }

    @Nested
    final class Leaving {
        Leaving() {
        }

        @Test
        void followerCanLeaveCluster(@TempDir Path tmp) {
            MemberId id1 = MemberId.from((String)"1");
            MemberId id2 = MemberId.from((String)"2");
            MemberId id3 = MemberId.from((String)"3");
            RaftServer m1 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id1, id2, id3));
            RaftServer m2 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id2, id1, id3));
            RaftServer m3 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id3, id1, id2));
            CompletableFuture.allOf(m1.bootstrap(new MemberId[]{id1, id2, id3}), m2.bootstrap(new MemberId[]{id1, id2, id3}), m3.bootstrap(new MemberId[]{id1, id2, id3})).join();
            ReconfigurationTest.awaitLeader(m1, m2, m3);
            RaftServer follower = Stream.of(m1, m2, m3).filter(s -> !s.isLeader()).findAny().orElseThrow();
            List<RaftServer> others = Stream.of(m1, m2, m3).filter(s -> s != follower).toList();
            follower.leave().join();
            List<RaftMember> expected = others.stream().map(server -> server.cluster().getLocalMember()).toList();
            Awaitility.await((String)"All members have configuration with 2 active members").untilAsserted(() -> Assertions.assertThat((List)others).allSatisfy(member -> Assertions.assertThat((Collection)member.cluster().getMembers()).containsExactlyInAnyOrderElementsOf((Iterable)expected)));
        }

        @Test
        void leaderCanLeaveCluster(@TempDir Path tmp) {
            MemberId id1 = MemberId.from((String)"1");
            MemberId id2 = MemberId.from((String)"2");
            MemberId id3 = MemberId.from((String)"3");
            RaftServer m1 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id1, id2, id3));
            RaftServer m2 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id2, id1, id3));
            RaftServer m3 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id3, id1, id2));
            CompletableFuture.allOf(m1.bootstrap(new MemberId[]{id1, id2, id3}), m2.bootstrap(new MemberId[]{id1, id2, id3}), m3.bootstrap(new MemberId[]{id1, id2, id3})).join();
            ReconfigurationTest.awaitLeader(m1, m2, m3);
            RaftServer leader = Stream.of(m1, m2, m3).filter(RaftServer::isLeader).findAny().orElseThrow();
            List<RaftServer> others = Stream.of(m1, m2, m3).filter(s -> s != leader).toList();
            leader.leave().join();
            List<RaftMember> expected = others.stream().map(server -> server.cluster().getLocalMember()).toList();
            Assertions.assertThat(others).allSatisfy(member -> Assertions.assertThat((Collection)member.cluster().getMembers()).containsExactlyInAnyOrderElementsOf((Iterable)expected));
        }

        @Test
        void leaveIsIdempotent(@TempDir Path tmp) {
            MemberId id1 = MemberId.from((String)"1");
            MemberId id2 = MemberId.from((String)"2");
            RaftServer m1 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id1, id2));
            RaftServer m2 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id2, id1));
            CompletableFuture.allOf(m1.bootstrap(new MemberId[]{id1, id2}), m2.bootstrap(new MemberId[]{id1, id2})).join();
            Assertions.assertThat((CompletableFuture)m2.leave()).succeedsWithin(Duration.ofSeconds(5L));
            ReconfigurationTest.appendEntry(ReconfigurationTest.awaitLeader(m1)).commit().join();
            Assertions.assertThat((CompletableFuture)m2.leave()).succeedsWithin(Duration.ofSeconds(5L));
        }

        @Test
        void canLeaveAgainAfterRestart(@TempDir Path tmp) {
            MemberId id1 = MemberId.from((String)"1");
            MemberId id2 = MemberId.from((String)"2");
            RaftServer m1 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id1, id2));
            RaftServer m2 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id2, id1));
            CompletableFuture.allOf(m1.bootstrap(new MemberId[]{id1, id2}), m2.bootstrap(new MemberId[]{id1, id2})).join();
            Assertions.assertThat((CompletableFuture)m2.leave()).succeedsWithin(Duration.ofSeconds(5L));
            ReconfigurationTest.appendEntry(ReconfigurationTest.awaitLeader(m1)).commit().join();
            m2.shutdown().join();
            RaftServer m2Restarted = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id2, id1));
            CompletableFuture startFuture = m2Restarted.bootstrap(new MemberId[]{id1, id2});
            Assertions.assertThat((CompletableFuture)m2Restarted.leave()).succeedsWithin(Duration.ofSeconds(5L));
            Assertions.assertThat((CompletableFuture)startFuture).failsWithin(Duration.ofMillis(200L)).withThrowableOfType(ExecutionException.class).withCauseInstanceOf(RaftServer.CancelledBootstrapException.class);
        }

        @Test
        void shouldLeave2MemberCluster(@TempDir Path tmp) {
            MemberId id1 = MemberId.from((String)"1");
            MemberId id2 = MemberId.from((String)"2");
            RaftServer m1 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id1, id2));
            RaftServer m2 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id2, id1));
            CompletableFuture.allOf(m1.bootstrap(new MemberId[]{id1, id2}), m2.bootstrap(new MemberId[]{id1, id2})).join();
            m2.leave().join();
            List<DefaultRaftMember> expected = List.of(new DefaultRaftMember(id1, RaftMember.Type.ACTIVE, Instant.now()));
            Assertions.assertThat((Collection)m1.cluster().getMembers()).containsExactlyInAnyOrderElementsOf(expected);
        }

        @Test
        void cannotLeaveWhenNewConfigurationDoesNotHaveQuorum(@TempDir Path tmp) {
            MemberId id1 = MemberId.from((String)"1");
            MemberId id2 = MemberId.from((String)"2");
            MemberId id3 = MemberId.from((String)"3");
            RaftServer m1 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id1, id2, id3));
            RaftServer m2 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id2, id1, id3));
            RaftServer m3 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id3, id1, id2));
            CompletableFuture.allOf(m1.bootstrap(new MemberId[]{id1, id2, id3}), m2.bootstrap(new MemberId[]{id1, id2, id3}), m3.bootstrap(new MemberId[]{id1, id2, id3})).join();
            m3.shutdown().join();
            ReconfigurationTest.awaitLeader(m1, m2);
            ((CompletableFutureAssert)Assertions.assertThat((CompletableFuture)m2.leave()).describedAs("Should fail to leave because quorum not available for the new configuration", new Object[0])).failsWithin(Duration.ofSeconds(10L)).withThrowableOfType(ExecutionException.class);
        }

        @Test
        void shouldReduceQuorumSize(@TempDir Path tmp) {
            MemberId id1 = MemberId.from((String)"1");
            MemberId id2 = MemberId.from((String)"2");
            MemberId id3 = MemberId.from((String)"3");
            MemberId id4 = MemberId.from((String)"4");
            MemberId id5 = MemberId.from((String)"5");
            RaftServer m1 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id1, id2, id3));
            RaftServer m2 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id2, id1, id3));
            RaftServer m3 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id3, id1, id2));
            RaftServer m4 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id4, id1, id2, id3));
            RaftServer m5 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id5, id1, id2, id3));
            CompletableFuture.allOf(m1.bootstrap(new MemberId[]{id1, id2, id3, id4, id5}), m2.bootstrap(new MemberId[]{id1, id2, id3, id4, id5}), m3.bootstrap(new MemberId[]{id1, id2, id3, id4, id5}), m4.bootstrap(new MemberId[]{id1, id2, id3, id4, id5}), m5.bootstrap(new MemberId[]{id1, id2, id3, id4, id5})).join();
            Assertions.assertThat(ReconfigurationTest.appendEntry(ReconfigurationTest.awaitLeader(m1, m2, m3, m4, m5)).commit()).succeedsWithin(Duration.ofSeconds(1L));
            m4.leave().join();
            m4.shutdown().join();
            Assertions.assertThat(ReconfigurationTest.appendEntry(ReconfigurationTest.awaitLeader(m1, m2, m3, m5)).commit()).succeedsWithin(Duration.ofSeconds(1L));
            m5.leave().join();
            m5.shutdown().join();
            m3.shutdown().join();
            LeaderRole leader = ReconfigurationTest.awaitLeader(m1, m2);
            Assertions.assertThat(ReconfigurationTest.appendEntry(leader).commit()).succeedsWithin(Duration.ofSeconds(1L));
        }
    }

    @Nested
    final class Joining {
        Joining() {
        }

        @Test
        void rejoinShouldBeSuccessful(@TempDir Path tmp) {
            MemberId id1 = MemberId.from((String)"1");
            MemberId id2 = MemberId.from((String)"2");
            MemberId id3 = MemberId.from((String)"3");
            RaftServer m1 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id1, id2, id3));
            RaftServer m2 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id2, id1, id3));
            RaftServer m3 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id3, id2, id1));
            CompletableFuture.allOf(m1.bootstrap(new MemberId[]{id1, id2, id3}), m2.bootstrap(new MemberId[]{id1, id2, id3})).join();
            m3.join(new MemberId[]{id1, id2}).join();
            m3.shutdown().join();
            m3.join(new MemberId[]{id1, id2}).join();
        }

        @Test
        void canJoinAgainAfterDataloss(@TempDir Path tmp) throws IOException {
            MemberId id1 = MemberId.from((String)"1");
            MemberId id2 = MemberId.from((String)"2");
            MemberId id3 = MemberId.from((String)"3");
            RaftServer m1 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id1, id2, id3));
            RaftServer m2 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id2, id1, id3));
            RaftServer m3 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id3, id2, id1));
            CompletableFuture.allOf(m1.bootstrap(new MemberId[]{id1, id2, id3}), m2.bootstrap(new MemberId[]{id1, id2, id3})).join();
            m3.join(new MemberId[]{id1, id2}).join();
            m3.shutdown().join();
            ReconfigurationTest.this.servers.remove(m3);
            FileUtil.deleteFolder((Path)tmp.resolve(id3.toString()));
            Files.createDirectory(tmp.resolve(id3.toString()), new FileAttribute[0]);
            RaftServer recreatedM3 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id3, id2, id1));
            recreatedM3.join(new MemberId[]{id1, id2}).join();
            LeaderRole leader = ReconfigurationTest.awaitLeader(m1, m2);
            Long index = ReconfigurationTest.appendEntry(leader).write().join();
            Awaitility.await((String)"All members have committed the entry").untilAsserted(() -> Assertions.assertThat(List.of(m1, m2, recreatedM3)).allSatisfy(server -> Assertions.assertThat((long)server.getContext().getCommitIndex()).isEqualTo((Object)index)));
        }

        @Test
        void shouldJoinExistingMembers(@TempDir Path tmp) {
            MemberId id1 = MemberId.from((String)"1");
            MemberId id2 = MemberId.from((String)"2");
            MemberId id3 = MemberId.from((String)"3");
            RaftServer m1 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id1, id2, id3));
            RaftServer m2 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id2, id1, id3));
            RaftServer m3 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id3, id1, id2));
            CompletableFuture.allOf(m1.bootstrap(new MemberId[]{id1, id2, id3}), m2.bootstrap(new MemberId[]{id1, id2, id3}), m3.bootstrap(new MemberId[]{id1, id2, id3})).join();
            MemberId id4 = MemberId.from((String)"4");
            RaftServer m4 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id4, id1, id2, id3));
            m4.join(new MemberId[]{id1, id2, id3}).join();
            List<DefaultRaftMember> expected = List.of(new DefaultRaftMember(id1, RaftMember.Type.ACTIVE, Instant.now()), new DefaultRaftMember(id2, RaftMember.Type.ACTIVE, Instant.now()), new DefaultRaftMember(id3, RaftMember.Type.ACTIVE, Instant.now()), new DefaultRaftMember(id4, RaftMember.Type.ACTIVE, Instant.now()));
            Awaitility.await((String)"All members have configuration with 4 active members").untilAsserted(() -> Assertions.assertThat(List.of(m1, m2, m3, m4)).allSatisfy(member -> Assertions.assertThat((Collection)member.cluster().getMembers()).containsExactlyInAnyOrderElementsOf((Iterable)expected)));
        }

        @Test
        void shouldCommitOnAllMembers(@TempDir Path tmp) {
            MemberId id1 = MemberId.from((String)"1");
            MemberId id2 = MemberId.from((String)"2");
            MemberId id3 = MemberId.from((String)"3");
            MemberId id4 = MemberId.from((String)"4");
            RaftServer m1 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id1, id2, id3));
            RaftServer m2 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id2, id1, id3));
            RaftServer m3 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id3, id1, id2));
            RaftServer m4 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id4, id1, id2, id3));
            CompletableFuture.allOf(m1.bootstrap(new MemberId[]{id1, id2, id3}), m2.bootstrap(new MemberId[]{id1, id2, id3}), m3.bootstrap(new MemberId[]{id1, id2, id3})).join();
            m4.join(new MemberId[]{id1, id2, id3}).join();
            LeaderRole leader = ReconfigurationTest.awaitLeader(m1, m2, m3, m4);
            Long index = ReconfigurationTest.appendEntry(leader).write().join();
            Awaitility.await((String)"All members have committed the entry").untilAsserted(() -> Assertions.assertThat(List.of(m1, m2, m3, m4)).allSatisfy(server -> Assertions.assertThat((long)server.getContext().getCommitIndex()).isEqualTo((Object)index)));
        }

        @Test
        void shouldRequireAdjustedQuorum(@TempDir Path tmp) {
            MemberId id1 = MemberId.from((String)"1");
            MemberId id2 = MemberId.from((String)"2");
            MemberId id3 = MemberId.from((String)"3");
            MemberId id4 = MemberId.from((String)"4");
            MemberId id5 = MemberId.from((String)"5");
            RaftServer m1 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id1, id2, id3));
            RaftServer m2 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id2, id1, id3));
            RaftServer m3 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id3, id1, id2));
            RaftServer m4 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id4, id1, id2, id3));
            RaftServer m5 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id5, id1, id2, id3));
            CompletableFuture.allOf(m1.bootstrap(new MemberId[]{id1, id2, id3}), m2.bootstrap(new MemberId[]{id1, id2, id3}), m3.bootstrap(new MemberId[]{id1, id2, id3})).join();
            m4.join(new MemberId[]{id1, id2, id3}).join();
            m5.join(new MemberId[]{id1, id2, id3}).join();
            m1.shutdown().join();
            m4.shutdown().join();
            m5.shutdown().join();
            Awaitility.await((String)"No leader is elected").during(Duration.ofSeconds(5L)).until(() -> ReconfigurationTest.getLeader(m1, m2, m3, m4, m5), Optional::isEmpty);
        }

        @Test
        void shouldFormNewQuorum(@TempDir Path tmp) {
            MemberId id1 = MemberId.from((String)"1");
            MemberId id2 = MemberId.from((String)"2");
            MemberId id3 = MemberId.from((String)"3");
            MemberId id4 = MemberId.from((String)"4");
            MemberId id5 = MemberId.from((String)"5");
            RaftServer m1 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id1, id2, id3));
            RaftServer m2 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id2, id1, id3));
            RaftServer m3 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id3, id1, id2));
            RaftServer m4 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id4, id1, id2, id3));
            RaftServer m5 = ReconfigurationTest.this.createServer(tmp, ReconfigurationTest.this.createMembershipService(id5, id1, id2, id3));
            CompletableFuture.allOf(m1.bootstrap(new MemberId[]{id1, id2, id3}), m2.bootstrap(new MemberId[]{id1, id2, id3}), m3.bootstrap(new MemberId[]{id1, id2, id3})).join();
            m4.join(new MemberId[]{id1, id2, id3}).join();
            m5.join(new MemberId[]{id1, id2, id3}).join();
            m1.shutdown().join();
            m2.shutdown().join();
            LeaderRole leader = ReconfigurationTest.awaitLeader(m1, m2, m3, m4, m5);
            Assertions.assertThat(ReconfigurationTest.appendEntry(leader).commit()).succeedsWithin(Duration.ofSeconds(1L));
        }
    }
}

