/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft;

import io.atomix.cluster.MemberId;
import io.atomix.raft.RaftRule;
import io.atomix.raft.RaftServer;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.Rule;
import org.junit.Test;
import org.junit.jupiter.api.DisplayName;

public class RaftCorruptedDataTest {
    @Rule
    public RaftRule raftRule = RaftRule.withBootstrappedNodes(3);

    @Test
    @DisplayName(value="When nodes with corrupted data forms a quorum, the remaining one should not delete its files")
    public void upToDateFollowerShouldNotLoseDataWhenQuorumExperienceCorruption() throws Exception {
        RaftServer[] servers = (RaftServer[])this.raftRule.getServers().toArray(RaftServer[]::new);
        MemberId node0 = MemberId.from((String)servers[0].name());
        MemberId node1 = MemberId.from((String)servers[1].name());
        MemberId node2 = MemberId.from((String)servers[2].name());
        this.raftRule.appendEntries(100);
        this.raftRule.appendEntries(1);
        Awaitility.await((String)"commitIndex is > 0 on all nodes").until(() -> Arrays.stream(servers).allMatch(s -> s.getContext().getCommitIndex() >= 100L));
        long commitIndex = servers[2].getContext().getCommitIndex();
        for (RaftServer server : servers) {
            this.raftRule.shutdownServer(server);
        }
        this.raftRule.triggerDataLossOnNode((String)((Object)node0.id()));
        this.raftRule.triggerDataLossOnNode((String)((Object)node1.id()));
        RaftServer server1 = this.raftRule.createServer(node0);
        RaftServer server2 = this.raftRule.createServer(node1);
        CompletableFuture.allOf(server1.bootstrap(new MemberId[]{node0, node1, node2}), server2.bootstrap(new MemberId[]{node0, node1, node2})).join();
        Awaitility.await((String)"corrupted nodes form a quorum").until(() -> server1.isLeader() || server2.isLeader());
        RaftServer server3 = this.raftRule.createServer(node2);
        Assertions.assertThatThrownBy(() -> server3.bootstrap(new MemberId[]{node0, node1, node2}).get(2L, TimeUnit.SECONDS)).isExactlyInstanceOf(TimeoutException.class);
        Awaitility.await((String)"node becomes INACTIVE").until(() -> server3.getRole().equals((Object)RaftServer.Role.INACTIVE));
    }
}

