/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.metrics;

import io.atomix.raft.metrics.RaftKeyNames;
import io.atomix.raft.metrics.RaftMetrics;
import io.atomix.raft.metrics.RaftRoleMetricsDoc;
import io.camunda.zeebe.util.micrometer.StatefulGauge;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.TimeUnit;

public class RaftRoleMetrics
extends RaftMetrics {
    private final Counter heartbeatMiss;
    private final Timer heartbeatTime;
    private final StatefulGauge role;
    private final StatefulGauge electionLatency;

    public RaftRoleMetrics(String partitionName, MeterRegistry registry) {
        super(partitionName);
        this.heartbeatMiss = Counter.builder((String)RaftRoleMetricsDoc.HEARTBEAT_MISS.getName()).description(RaftRoleMetricsDoc.HEARTBEAT_MISS.getDescription()).tag(RaftKeyNames.PARTITION_GROUP.asString(), this.partitionGroupName).register(registry);
        this.heartbeatTime = Timer.builder((String)RaftRoleMetricsDoc.HEARTBEAT_TIME.getName()).description(RaftRoleMetricsDoc.HEARTBEAT_TIME.getDescription()).serviceLevelObjectives(RaftRoleMetricsDoc.HEARTBEAT_TIME.getTimerSLOs()).tag(RaftKeyNames.PARTITION_GROUP.asString(), this.partitionGroupName).register(registry);
        this.role = StatefulGauge.builder((String)RaftRoleMetricsDoc.ROLE.getName()).description(RaftRoleMetricsDoc.ROLE.getDescription()).tag(RaftKeyNames.PARTITION_GROUP.asString(), this.partitionGroupName).register(registry);
        this.electionLatency = StatefulGauge.builder((String)RaftRoleMetricsDoc.ELECTION_LATENCY.getName()).description(RaftRoleMetricsDoc.ELECTION_LATENCY.getDescription()).tag(RaftKeyNames.PARTITION_GROUP.asString(), partitionName).register(registry);
    }

    public void becomingInactive() {
        this.role.set(0L);
    }

    public void becomingFollower() {
        this.role.set(1L);
    }

    public void becomingCandidate() {
        this.role.set(2L);
    }

    public void becomingLeader() {
        this.role.set(3L);
    }

    public void countHeartbeatMiss() {
        this.heartbeatMiss.increment();
    }

    public void observeHeartbeatInterval(long milliseconds) {
        this.heartbeatTime.record(milliseconds, TimeUnit.MILLISECONDS);
    }

    public double getHeartbeatMissCount() {
        return this.heartbeatMiss.count();
    }

    public void setElectionLatency(long latencyMs) {
        this.electionLatency.set(latencyMs);
    }
}

